/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.api.util.helper.LogicHelper;
import com.pixelmonmod.tcg.api.util.helper.SelectorHelper;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;

public class PokemonTrader
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        PlayerClientMyState me = client.getMe();
        return me.getHand().stream().anyMatch(c -> c.getCardType().isPokemon());
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        if (trainer.getParameters().size() == 0) {
            return SelectorHelper.generateSelectorForSelectPokemonFromHand(me, 1, null);
        }
        if (trainer.getParameters().size() == 1) {
            return SelectorHelper.generateSelectorForSelectPokemonFromDeck(me, 1, null);
        }
        return null;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        if (!server.getPlayer(server.getCurrentTurn()).getDeck().stream().anyMatch(c -> c.getCardType().isPokemon())) {
            return true;
        }
        return trainer.getParameters().size() == 2;
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        if (trainer.getParameters().size() != 2) {
            return;
        }
        CommonCardState handCard = trainer.getParameters().get(0);
        CommonCardState deckCard = trainer.getParameters().get(1);
        PlayerServerState me = server.getPlayer(server.getCurrentTurn());
        me.getHand().remove(handCard.getData());
        me.getDeck().add(handCard.getData());
        me.getDeck().remove(deckCard.getData());
        me.getHand().add(deckCard.getData());
        LogicHelper.shuffleCardList(me.getDeck());
        CardSelectorState selector = new CardSelectorState(0, 0, CardSelectorDisplay.Reveal, false, "trainer.pokemontrader.selector.reveal");
        selector.getCardList().add(new CardWithLocation(handCard, true, BoardLocation.Hand, 0));
        selector.getCardList().add(new CardWithLocation(deckCard, true, BoardLocation.Deck, 0));
        server.getPlayer(server.getNextTurn()).setCardSelectorState(selector);
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

