/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.accessors.CardBacks;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Coins;
import com.pixelmonmod.tcg.api.accessors.TCGBlocks;
import com.pixelmonmod.tcg.api.card.personalization.CardBack;
import com.pixelmonmod.tcg.api.card.personalization.Coin;
import com.pixelmonmod.tcg.api.card.set.CardSet;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TCGTrades {
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> TCG_TRADER_TRADES;

    private static Int2ObjectMap<VillagerTrades.ITrade[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    static {
        ArrayList trades = Lists.newArrayList();
        for (DyeColor color : DyeColor.values()) {
            for (CardSet set : CardSets.getAll()) {
                if (!set.hasPack()) continue;
                trades.add(new EssenceJarForItemStack(25, set::getItemStack, color));
            }
            if (!TCGConfigProxy.getConfig().shouldGenerateCosmeticsInCardShop()) continue;
            for (CardBack cardBack : CardBacks.getAll()) {
                trades.add(new EssenceJarForItemStack(25, cardBack::getItemStack, color));
            }
            for (Coin coin : Coins.getAll()) {
                trades.add(new EssenceJarForItemStack(25, coin::getItemStack, color));
            }
        }
        TCG_TRADER_TRADES = TCGTrades.toIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.builder().put((Object)1, (Object)trades.toArray(new VillagerTrades.ITrade[0])).build());
    }

    static class EssenceJarForItemStack
    implements VillagerTrades.ITrade {
        final int xp;
        private final Supplier<ItemStack> itemStack;
        private final String name;
        private final Color color;

        public EssenceJarForItemStack(int xp, Supplier<ItemStack> itemStack, DyeColor color) {
            this.xp = xp;
            this.itemStack = itemStack;
            this.name = ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent("color.minecraft." + color.func_176762_d()));
            this.color = new Color(color.getColorValue());
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity entity, Random rand) {
            if (this.itemStack == null) {
                return null;
            }
            ItemStack cost = new ItemStack((IItemProvider)TCGBlocks.essence_jar, 1);
            cost.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarCount", TCGConfigProxy.getConfig().getEssenceToFillJar());
            cost.func_190925_c("BlockEntityTag").func_74780_a("EssenceJarPercent", 1.0);
            cost.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorRed", this.color.getRed());
            cost.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorGreen", this.color.getGreen());
            cost.func_190925_c("BlockEntityTag").func_74768_a("EssenceJarColorBlue", this.color.getBlue());
            cost.func_190925_c("BlockEntityTag").func_74778_a("EssenceJarColorName", this.name);
            return new MerchantOffer(cost, this.itemStack.get(), Integer.MAX_VALUE, this.xp, 0.0f);
        }
    }
}

