/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.config.TCGConfigProxy;
import com.pixelmonmod.tcg.client.gui.PackScreen;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class OpenPackGuiPacket
extends AbstractTCGPacket {
    private ImmutableCard[] cards;

    public OpenPackGuiPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public OpenPackGuiPacket(ImmutableCard[] cards) {
        this();
        this.cards = cards;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.cards.length);
        for (ImmutableCard card : this.cards) {
            ByteBufTCG.writeCard(buffer, card);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        this.cards = new ImmutableCard[size];
        for (int i = 0; i < size; ++i) {
            this.cards[i] = ByteBufTCG.readCard(buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (TCGConfigProxy.getConfig() != null) {
                TCGConfigProxy.getConfig().setSavedUIScale(mc.field_71474_y.field_74335_Z);
                mc.field_71474_y.field_74335_Z = 4;
            }
            mc.func_147108_a((Screen)new PackScreen(0, this.cards));
        }
    }
}

