/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.TCG;
import com.pixelmonmod.tcg.api.accessors.CardSets;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.accessors.TCGItems;
import com.pixelmonmod.tcg.api.card.CardRarity;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.events.PackOpenEvent;
import com.pixelmonmod.tcg.item.PackItem;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.OpenPackGuiPacket;
import java.util.ArrayList;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class OpenPackPacket
extends AbstractTCGPacket {
    private int id;

    public OpenPackPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public OpenPackPacket(int id) {
        this();
        this.id = id;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.id);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.id = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ItemStack itemInHand = player.func_184586_b(Hand.MAIN_HAND);
        if (itemInHand == ItemStack.field_190927_a) {
            return;
        }
        if (!(itemInHand.func_77973_b() instanceof PackItem)) {
            return;
        }
        int setID = itemInHand.func_77978_p().func_74762_e("SetID");
        float weight = itemInHand.func_77978_p().func_74760_g("Weight");
        ImmutableCard[] c = new ImmutableCard[]{Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.COMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRandomCardOfRarity(setID, CardRarity.UNCOMMON, false), Cards.getRareOrBetterCard(setID, weight, true), Cards.getRandomBasicEnergyCard()};
        PackOpenEvent.Pre preEvent = new PackOpenEvent.Pre(player, itemInHand, c);
        if (TCG.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        if (!player.func_184812_l_()) {
            itemInHand.func_190918_g(1);
        }
        int dropped = 0;
        int givenCards = 0;
        for (int i = 0; i < preEvent.getCards().length; ++i) {
            ImmutableCard[] cz = preEvent.getCards()[i];
            if (cz == null) continue;
            ItemStack itemStack = c[i].getItemStack(1);
            if (!player.func_191521_c(itemStack)) {
                player.func_71019_a(itemStack, true);
                ++dropped;
            }
            ++givenCards;
        }
        TCG.EVENT_BUS.post((Event)new PackOpenEvent.Post(player, itemInHand, preEvent.getCards()));
        ArrayList nonNullCards = Lists.newArrayList();
        for (ImmutableCard immutableCard : c) {
            if (immutableCard == null) continue;
            nonNullCards.add(immutableCard);
        }
        ImmutableCard[] nonNullCardArray = nonNullCards.toArray(new ImmutableCard[0]);
        player.func_71120_a((Container)player.field_71069_bz);
        if (dropped > 0) {
            ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.drops.fullinventory", dropped + " " + new TranslationTextComponent(TCGItems.card.func_200295_i(null) + ".name"));
        }
        if (givenCards > 0) {
            this.reply(context, new OpenPackGuiPacket(nonNullCardArray));
        } else {
            TCG.LOGGER.error("Card Set: " + CardSets.get(setID).getName() + " has no valid cards!");
        }
    }
}

