/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.duel.attack.enums.CoinSide;
import com.pixelmonmod.tcg.duel.log.DuelLog;
import com.pixelmonmod.tcg.duel.state.CoinFlipState;
import com.pixelmonmod.tcg.duel.state.GamePhase;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerClientMyState;
import com.pixelmonmod.tcg.duel.state.PlayerClientOpponentState;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class GameStateSyncPacket
extends AbstractTCGPacket {
    private boolean isSpectating;
    private BlockPos blockPos;
    private GamePhase gamePhase;
    private int playerIndex;
    private boolean isMyTurn;
    private PlayerClientMyState myState;
    private PlayerClientOpponentState oppState;
    private DuelLog log;
    private int turnCount;
    private CoinFlipState coinFlip;
    private GameServerState server;

    public GameStateSyncPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public GameStateSyncPacket(BlockPos blockPos, int playerIndex, boolean isSpectating, GameServerState server, PlayerEntity entityPlayer) {
        this();
        this.blockPos = blockPos;
        this.playerIndex = playerIndex;
        this.isSpectating = isSpectating;
        this.gamePhase = server.getGamePhase();
        this.isMyTurn = server.getCurrentTurn() == playerIndex;
        this.myState = new PlayerClientMyState(server.getPlayer(playerIndex), server.getGamePhase(), server, isSpectating);
        this.oppState = new PlayerClientOpponentState(server.getOpponent(playerIndex), server.getGamePhase(), server, false);
        this.log = server.getLog();
        this.turnCount = server.getTurnCount();
        if (server.getCoinFlip() != null && server.getRevealedCoinFlipResults() <= server.getCoinFlip().getResults().size()) {
            ArrayList<CoinSide> truncatedResults = new ArrayList<CoinSide>();
            for (int i = 0; i < server.getRevealedCoinFlipResults(); ++i) {
                truncatedResults.add(server.getCoinFlip().getResults().get(i));
            }
            this.coinFlip = new CoinFlipState(truncatedResults, server.getCoinFlip().getPlayerIndex());
        }
        this.server = server;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.gamePhase.ordinal());
        buffer.writeInt(this.playerIndex);
        buffer.writeBoolean(this.isMyTurn);
        this.myState.write(buffer);
        this.oppState.write(buffer);
        this.log.write(buffer, this.gamePhase, this.isSpectating ? -1 : this.playerIndex, this.isMyTurn);
        buffer.writeInt(this.turnCount);
        buffer.writeBoolean(this.coinFlip != null);
        if (this.coinFlip != null) {
            buffer.writeInt(this.coinFlip.getResults().size());
            for (CoinSide result : this.coinFlip.getResults()) {
                buffer.writeInt(result.ordinal());
            }
            buffer.writeInt(this.coinFlip.getPlayerIndex());
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.gamePhase = GamePhase.values()[buffer.readInt()];
        this.playerIndex = buffer.readInt();
        this.isMyTurn = buffer.readBoolean();
        this.myState = new PlayerClientMyState(buffer, this.server);
        this.oppState = new PlayerClientOpponentState(buffer, this.server);
        this.log = new DuelLog(buffer);
        this.turnCount = buffer.readInt();
        if (buffer.readBoolean()) {
            ArrayList<CoinSide> coinFlipResults = new ArrayList<CoinSide>();
            int flipCount = buffer.readInt();
            for (int i = 0; i < flipCount; ++i) {
                coinFlipResults.add(CoinSide.values()[buffer.readInt()]);
            }
            int playerIndex = buffer.readInt();
            this.coinFlip = new CoinFlipState(coinFlipResults, playerIndex);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        ClientWorld w;
        BattleOwnedTileEntityController b;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity e = mc.field_71439_g;
        if (mc.field_71441_e != null && (b = (BattleOwnedTileEntityController)(w = mc.field_71441_e).func_175625_s(this.blockPos)) != null) {
            b.setClientSideValues(this.gamePhase, this.playerIndex, this.isMyTurn, this.myState, this.oppState, this.log, this.turnCount, this.coinFlip);
        }
    }
}

