/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.network.packets.battles;

import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.network.ByteBufTCG;
import com.pixelmonmod.tcg.network.data.AbstractTCGPacket;
import com.pixelmonmod.tcg.network.data.PacketDirection;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import com.pixelmonmod.tcg.tileentity.BattleOwnedTileEntityController;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdateServerCardRecordPacket
extends AbstractTCGPacket {
    private BlockPos blockPos;
    private BoardLocation location;
    private int locationSubIndex;
    private ImmutableCard card;
    private int handIndex;

    public UpdateServerCardRecordPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public UpdateServerCardRecordPacket(BlockPos blockPos, BoardLocation location, int locationSubIndex, ImmutableCard card, int handIndex) {
        this();
        this.blockPos = blockPos;
        this.location = location;
        this.locationSubIndex = locationSubIndex;
        this.card = card;
        this.handIndex = handIndex;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.blockPos);
        buffer.writeInt(this.location.ordinal());
        buffer.writeInt(this.locationSubIndex);
        ByteBufTCG.writeCard(buffer, this.card);
        buffer.writeInt(this.handIndex);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.blockPos = buffer.func_179259_c();
        this.location = BoardLocation.values()[buffer.readInt()];
        this.locationSubIndex = buffer.readInt();
        this.card = ByteBufTCG.readCard(buffer);
        this.handIndex = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity e = context.getSender();
        ServerWorld w = e.func_71121_q();
        BattleOwnedTileEntityController b = (BattleOwnedTileEntityController)w.func_175625_s(this.blockPos);
        PlayerServerState player = null;
        for (PlayerServerState p : b.getGameServer().getPlayers()) {
            if (p == null || p.getEntityPlayer() != e) continue;
            player = p;
        }
        if (player == null) {
            return;
        }
        switch (this.location) {
            case Active: {
                b.playCardFromHandToActive(player, this.handIndex, this.card);
                return;
            }
            case Bench: {
                b.playPokemonCardToBench(player, this.handIndex, this.card, this.locationSubIndex);
                return;
            }
            case Trainer: {
                b.playTrainerCard(player, this.handIndex, this.card);
                return;
            }
            case Stadium: {
                b.playStadiumCard(player, this.handIndex, this.card);
                return;
            }
        }
    }
}

