/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.FileDialogUtil;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.OptionMenuConstructor;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class ShaderPackOptionList
extends IrisObjectSelectionList<BaseEntry> {
    private final List<AbstractElementWidget<?>> elementWidgets = new ArrayList();
    private final ShaderPackScreen screen;
    private final NavigationController navigation;
    private OptionMenuContainer container;

    public ShaderPackOptionList(ShaderPackScreen screen, NavigationController navigation, ShaderPack pack, Minecraft client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, left, right, 24);
        this.navigation = navigation;
        this.screen = screen;
        this.applyShaderPack(pack);
    }

    public void applyShaderPack(ShaderPack pack) {
        this.container = pack.getMenuContainer();
    }

    public void rebuild() {
        this.func_230963_j_();
        this.func_230932_a_(0.0);
        OptionMenuConstructor.constructAndApplyToScreen(this.container, this.screen, this, this.navigation);
    }

    public void refresh() {
        this.elementWidgets.forEach(widget -> widget.init(this.screen, this.navigation));
    }

    public int func_230949_c_() {
        return Math.min(400, this.field_230670_d_ - 12);
    }

    public void addHeader(ITextComponent text, boolean backButton) {
        this.func_230513_b_((AbstractList.AbstractListEntry)new HeaderEntry(this.screen, this.navigation, text, backButton));
    }

    public void addWidgets(int columns, List<AbstractElementWidget<?>> elements) {
        this.elementWidgets.addAll(elements);
        ArrayList<AbstractElementWidget<Object>> row = new ArrayList();
        for (AbstractElementWidget<?> element : elements) {
            row.add(element);
            if (row.size() < columns) continue;
            this.func_230513_b_((AbstractList.AbstractListEntry)new ElementRowEntry(this.screen, this.navigation, row));
            row = new ArrayList();
        }
        if (row.size() > 0) {
            while (row.size() < columns) {
                row.add(AbstractElementWidget.EMPTY);
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new ElementRowEntry(this.screen, this.navigation, row));
        }
    }

    public NavigationController getNavigation() {
        return this.navigation;
    }

    public static class HeaderEntry
    extends BaseEntry {
        public static final ITextComponent BACK_BUTTON_TEXT = new StringTextComponent("< ").func_230529_a_((ITextComponent)new TranslationTextComponent("options.iris.back").func_240699_a_(TextFormatting.ITALIC));
        public static final IFormattableTextComponent RESET_BUTTON_TEXT_INACTIVE = new TranslationTextComponent("options.iris.reset").func_240699_a_(TextFormatting.GRAY);
        public static final IFormattableTextComponent RESET_BUTTON_TEXT_ACTIVE = new TranslationTextComponent("options.iris.reset").func_240699_a_(TextFormatting.YELLOW);
        public static final IFormattableTextComponent RESET_HOLD_SHIFT_TOOLTIP = new TranslationTextComponent("options.iris.reset.tooltip.holdShift").func_240699_a_(TextFormatting.GOLD);
        public static final IFormattableTextComponent RESET_TOOLTIP = new TranslationTextComponent("options.iris.reset.tooltip").func_240699_a_(TextFormatting.RED);
        public static final IFormattableTextComponent IMPORT_TOOLTIP = new TranslationTextComponent("options.iris.importSettings.tooltip").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)5089023)));
        public static final IFormattableTextComponent EXPORT_TOOLTIP = new TranslationTextComponent("options.iris.exportSettings.tooltip").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)16547133)));
        private static final int MIN_SIDE_BUTTON_WIDTH = 42;
        private static final int BUTTON_HEIGHT = 16;
        private final ShaderPackScreen screen;
        @Nullable
        private final IrisElementRow backButton;
        private final IrisElementRow utilityButtons = new IrisElementRow();
        private final IrisElementRow.TextButtonElement resetButton;
        private final IrisElementRow.IconButtonElement importButton;
        private final IrisElementRow.IconButtonElement exportButton;
        private final ITextComponent text;

        public HeaderEntry(ShaderPackScreen screen, NavigationController navigation, ITextComponent text, boolean hasBackButton) {
            super(navigation);
            this.backButton = hasBackButton ? new IrisElementRow().add(new IrisElementRow.TextButtonElement(BACK_BUTTON_TEXT, this::backButtonClicked), Math.max(42, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)BACK_BUTTON_TEXT) + 8)) : null;
            this.resetButton = new IrisElementRow.TextButtonElement((ITextComponent)RESET_BUTTON_TEXT_INACTIVE, this::resetButtonClicked);
            this.importButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.IMPORT, GuiUtil.Icon.IMPORT_COLORED, this::importSettingsButtonClicked);
            this.exportButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.EXPORT, GuiUtil.Icon.EXPORT_COLORED, this::exportSettingsButtonClicked);
            this.utilityButtons.add(this.importButton, 15).add(this.exportButton, 15).add(this.resetButton, Math.max(42, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)RESET_BUTTON_TEXT_INACTIVE) + 8));
            this.screen = screen;
            this.text = text;
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            boolean shiftDown;
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)(x - 3), (int)(y + entryHeight - 2), (int)(x + entryWidth), (int)(y + entryHeight - 1), (int)0x66BEBEBE);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            AbstractGui.func_238472_a_((MatrixStack)poseStack, (FontRenderer)font, (ITextComponent)this.text, (int)(x + (int)((double)entryWidth * 0.5)), (int)(y + 5), (int)0xFFFFFF);
            GuiUtil.bindIrisWidgetsTexture();
            if (this.backButton != null) {
                this.backButton.render(poseStack, x, y, 16, mouseX, mouseY, tickDelta, hovered);
            }
            this.resetButton.disabled = !(shiftDown = Screen.func_231173_s_());
            this.resetButton.text = shiftDown ? RESET_BUTTON_TEXT_ACTIVE : RESET_BUTTON_TEXT_INACTIVE;
            this.utilityButtons.renderRightAligned(poseStack, x + entryWidth - 3, y, 16, mouseX, mouseY, tickDelta, hovered);
            if (this.resetButton.isHovered()) {
                IFormattableTextComponent tooltip = shiftDown ? RESET_TOOLTIP : RESET_HOLD_SHIFT_TOOLTIP;
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (ITextComponent)tooltip);
            }
            if (this.importButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (ITextComponent)IMPORT_TOOLTIP);
            }
            if (this.exportButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(poseStack, mouseX, mouseY, font, (ITextComponent)EXPORT_TOOLTIP);
            }
        }

        private void queueBottomRightAnchoredTooltip(MatrixStack poseStack, int x, int y, FontRenderer font, ITextComponent text) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(font, poseStack, text, x - (font.func_238414_a_((ITextProperties)text) + 10), y - 16));
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            boolean backButtonResult = this.backButton != null && this.backButton.mouseClicked(mouseX, mouseY, button);
            boolean utilButtonResult = this.utilityButtons.mouseClicked(mouseX, mouseY, button);
            return backButtonResult || utilButtonResult;
        }

        private boolean backButtonClicked(IrisElementRow.TextButtonElement button) {
            this.navigation.back();
            GuiUtil.playButtonClickSound();
            return true;
        }

        private boolean resetButtonClicked(IrisElementRow.TextButtonElement button) {
            if (Screen.func_231173_s_()) {
                Iris.resetShaderPackOptionsOnNextReload();
                this.screen.applyChanges();
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        }

        private boolean importSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            if (Minecraft.func_71410_x().func_228018_at_().func_198113_j()) {
                this.screen.displayNotification((ITextComponent)new TranslationTextComponent("options.iris.mustDisableFullscreen").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
                return false;
            }
            ShaderPackScreen originalScreen = this.screen;
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.OPEN, "Import Shader Settings from File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((path, err) -> {
                if (err != null) {
                    Iris.logger.error("Error selecting shader settings from file", (Throwable)err);
                    return;
                }
                if (Minecraft.func_71410_x().field_71462_r == originalScreen) {
                    path.ifPresent(originalScreen::importPackOptions);
                }
            });
            return true;
        }

        private boolean exportSettingsButtonClicked(IrisElementRow.IconButtonElement button) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            if (Minecraft.func_71410_x().func_228018_at_().func_198113_j()) {
                this.screen.displayNotification((ITextComponent)new TranslationTextComponent("options.iris.mustDisableFullscreen").func_240699_a_(TextFormatting.RED).func_240699_a_(TextFormatting.BOLD));
                return false;
            }
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.SAVE, "Export Shader Settings to File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((path, err) -> {
                if (err != null) {
                    Iris.logger.error("Error selecting file to export shader settings", (Throwable)err);
                    return;
                }
                path.ifPresent(p -> {
                    Properties toSave = new Properties();
                    Path sourceTxtPath = Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt");
                    if (Files.exists(sourceTxtPath, new LinkOption[0])) {
                        try (InputStream in2 = Files.newInputStream(sourceTxtPath, new OpenOption[0]);){
                            toSave.load(in2);
                        }
                        catch (IOException in2) {
                            // empty catch block
                        }
                    }
                    try (OutputStream out = Files.newOutputStream(p, new OpenOption[0]);){
                        toSave.store(out, null);
                    }
                    catch (IOException e) {
                        Iris.logger.error("Error saving properties to \"" + p + "\"", e);
                    }
                });
            });
            return true;
        }
    }

    public static class ElementRowEntry
    extends BaseEntry {
        private final List<AbstractElementWidget<?>> widgets;
        private final ShaderPackScreen screen;
        private int cachedWidth;
        private int cachedPosX;

        public ElementRowEntry(ShaderPackScreen screen, NavigationController navigation, List<AbstractElementWidget<?>> widgets) {
            super(navigation);
            this.screen = screen;
            this.widgets = widgets;
        }

        public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.cachedWidth = entryWidth;
            this.cachedPosX = x;
            int totalWidthWithoutMargins = entryWidth - 2 * (this.widgets.size() - 1);
            float singleWidgetWidth = (float)(totalWidthWithoutMargins -= 3) / (float)this.widgets.size();
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractElementWidget<?> widget = this.widgets.get(i);
                boolean widgetHovered = hovered && this.getHoveredWidget(mouseX) == i;
                widget.render(poseStack, x + (int)((singleWidgetWidth + 2.0f) * (float)i), y, (int)singleWidgetWidth, entryHeight + 2, mouseX, mouseY, tickDelta, widgetHovered);
                this.screen.setElementHoveredStatus(widget, widgetHovered);
            }
        }

        public int getHoveredWidget(int mouseX) {
            float positionAcrossWidget = (float)MathHelper.func_76125_a((int)(mouseX - this.cachedPosX), (int)0, (int)this.cachedWidth) / (float)this.cachedWidth;
            return MathHelper.func_76125_a((int)((int)Math.floor((float)this.widgets.size() * positionAcrossWidget)), (int)0, (int)(this.widgets.size() - 1));
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            return this.widgets.get(this.getHoveredWidget((int)mouseX)).mouseClicked(mouseX, mouseY, button);
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            return this.widgets.get(this.getHoveredWidget((int)mouseX)).mouseReleased(mouseX, mouseY, button);
        }
    }

    public static abstract class BaseEntry
    extends ExtendedList.AbstractListEntry<BaseEntry> {
        protected final NavigationController navigation;

        protected BaseEntry(NavigationController navigation) {
            this.navigation = navigation;
        }
    }
}

