/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.fantastic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.coderbot.iris.fantastic.IrisParticleRenderTypes;
import net.coderbot.iris.fantastic.ParticleRenderingPhase;
import net.coderbot.iris.fantastic.PhasedParticleEngine;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ParticleManager.class})
public class MixinParticleEngine
implements PhasedParticleEngine {
    @Unique
    private ParticleRenderingPhase phase = ParticleRenderingPhase.EVERYTHING;
    private static final Set<IParticleRenderType> OPAQUE_PARTICLE_RENDER_TYPES = ImmutableSet.of((Object)IrisParticleRenderTypes.OPAQUE_TERRAIN, (Object)IParticleRenderType.field_217602_b, (Object)IParticleRenderType.field_217604_d, (Object)IParticleRenderType.field_217605_e, (Object)IParticleRenderType.field_217606_f);

    @Redirect(method={"renderParticles"}, at=@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;"), remap=false)
    private Set<IParticleRenderType> iris$selectParticlesToRender(Map<IParticleRenderType, Queue<Particle>> instance) {
        Set<IParticleRenderType> keySet = instance.keySet();
        if (this.phase == ParticleRenderingPhase.TRANSLUCENT) {
            return Sets.filter(keySet, type -> !OPAQUE_PARTICLE_RENDER_TYPES.contains(type));
        }
        if (this.phase == ParticleRenderingPhase.OPAQUE) {
            return Sets.filter(keySet, type -> !type.equals(IParticleRenderType.field_217603_c));
        }
        return keySet;
    }

    @Override
    public void setParticleRenderingPhase(ParticleRenderingPhase phase) {
        this.phase = phase;
    }
}

