/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.coderbot.iris.mixin.texture.TextureAtlasSpriteAccessor;
import net.coderbot.iris.texture.pbr.PBRAtlasHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasExtension;
import net.coderbot.iris.texture.util.TextureExporter;
import net.coderbot.iris.texture.util.TextureManipulationUtil;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PBRAtlasTexture
extends Texture {
    protected final AtlasTexture atlasTexture;
    protected final PBRType type;
    protected final ResourceLocation id;
    protected final Map<ResourceLocation, TextureAtlasSprite> sprites = new HashMap<ResourceLocation, TextureAtlasSprite>();
    protected final Set<TextureAtlasSprite> animatedSprites = new HashSet<TextureAtlasSprite>();

    public PBRAtlasTexture(AtlasTexture atlasTexture, PBRType type) {
        this.atlasTexture = atlasTexture;
        this.type = type;
        this.id = type.appendToFileLocation(atlasTexture.func_229223_g_());
    }

    public PBRType getType() {
        return this.type;
    }

    public ResourceLocation getAtlasId() {
        return this.id;
    }

    public void addSprite(TextureAtlasSprite sprite) {
        this.sprites.put(sprite.func_195668_m(), sprite);
        if (sprite.func_130098_m()) {
            this.animatedSprites.add(sprite);
        }
    }

    @Nullable
    public TextureAtlasSprite getSprite(ResourceLocation id) {
        return this.sprites.get(id);
    }

    public void clear() {
        this.sprites.clear();
        this.animatedSprites.clear();
    }

    public void upload(int atlasWidth, int atlasHeight, int mipLevel) {
        int glId = this.func_110552_b();
        TextureUtil.func_225681_a_((int)glId, (int)mipLevel, (int)atlasWidth, (int)atlasHeight);
        TextureManipulationUtil.fillWithColor(glId, mipLevel, this.type.getDefaultValue());
        for (TextureAtlasSprite sprite : this.sprites.values()) {
            try {
                this.uploadSprite(sprite);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashReportCategory = crashReport.func_85058_a("Texture being stitched together");
                crashReportCategory.func_71507_a("Atlas path", (Object)this.id);
                crashReportCategory.func_71507_a("Sprite", (Object)sprite);
                throw new ReportedException(crashReport);
            }
        }
        if (!this.animatedSprites.isEmpty()) {
            PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getOrCreatePBRHolder();
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(this);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(this);
                }
            }
        }
        if (PBRTextureManager.DEBUG) {
            TextureExporter.exportTextures("pbr_debug/atlas", this.id.func_110624_b() + "_" + this.id.func_110623_a().replaceAll("/", "_"), glId, mipLevel, atlasWidth, atlasHeight);
        }
    }

    public boolean tryUpload(int atlasWidth, int atlasHeight, int mipLevel) {
        try {
            this.upload(atlasWidth, atlasHeight, mipLevel);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected void uploadSprite(TextureAtlasSprite sprite) {
        if (sprite.func_130098_m()) {
            TextureAtlasSpriteAccessor accessor = (TextureAtlasSpriteAccessor)sprite;
            AnimationMetadataSection metadata = accessor.getMetadata();
            int frameCount = sprite.func_110970_k();
            for (int frame = accessor.getFrame(); frame >= 0; --frame) {
                int frameIndex = metadata.func_110468_c(frame);
                if (frameIndex < 0 || frameIndex >= frameCount) continue;
                accessor.callUpload(frameIndex);
                return;
            }
        }
        sprite.func_195663_q();
    }

    public void cycleAnimationFrames() {
        this.func_229148_d_();
        for (TextureAtlasSprite sprite : this.animatedSprites) {
            sprite.func_94219_l();
        }
    }

    public void close() {
        PBRAtlasHolder pbrHolder = ((TextureAtlasExtension)this.atlasTexture).getPBRHolder();
        if (pbrHolder != null) {
            switch (this.type) {
                case NORMAL: {
                    pbrHolder.setNormalAtlas(null);
                    break;
                }
                case SPECULAR: {
                    pbrHolder.setSpecularAtlas(null);
                }
            }
        }
    }

    public void func_195413_a(IResourceManager manager) {
    }
}

