/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.Util;
import org.apache.commons.io.FilenameUtils;

public class TextureExporter {
    public static void exportTextures(String directory, String filename, int textureId, int mipLevel, int width, int height) {
        String extension = FilenameUtils.getExtension((String)filename);
        String baseName = filename.substring(0, filename.length() - extension.length() - 1);
        for (int level = 0; level <= mipLevel; ++level) {
            TextureExporter.exportTexture(directory, baseName + "_" + level + "." + extension, textureId, level, width >> level, height >> level);
        }
    }

    public static void exportTexture(String directory, String filename, int textureId, int level, int width, int height) {
        NativeImage nativeImage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)textureId);
        nativeImage.func_195717_a(level, false);
        File dir = new File(Minecraft.func_71410_x().field_71412_D, directory);
        dir.mkdirs();
        File file = new File(dir, filename);
        Util.func_240992_g_().execute(() -> {
            try {
                nativeImage.func_209271_a(file);
            }
            catch (Exception exception) {
            }
            finally {
                nativeImage.close();
            }
        });
    }
}

