/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Matrix4f;

public final class MatrixUniforms {
    private MatrixUniforms() {
    }

    public static void addMatrixUniforms(UniformHolder uniforms, PackDirectives directives) {
        MatrixUniforms.addMatrix(uniforms, "ModelView", CapturedRenderingState.INSTANCE::getGbufferModelView);
        MatrixUniforms.addMatrix(uniforms, "Projection", CapturedRenderingState.INSTANCE::getGbufferProjection);
        MatrixUniforms.addShadowMatrix(uniforms, "ModelView", () -> ShadowRenderer.createShadowModelView(directives.getSunPathRotation(), directives.getShadowDirectives().getIntervalSize()).func_227866_c_().func_227870_a_().func_226601_d_());
        MatrixUniforms.addShadowArrayMatrix(uniforms, "Projection", () -> ShadowMatrices.createOrthoMatrix(directives.getShadowDirectives().getDistance()));
    }

    private static void addMatrix(UniformHolder uniforms, String name, Supplier<net.minecraft.util.math.vector.Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + name + "Inverse", new Inverted(supplier)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbufferPrevious" + name, new Previous(supplier));
    }

    private static void addShadowMatrix(UniformHolder uniforms, String name, Supplier<net.minecraft.util.math.vector.Matrix4f> supplier) {
        uniforms.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name + "Inverse", new Inverted(supplier));
    }

    private static void addShadowArrayMatrix(UniformHolder uniforms, String name, Supplier<float[]> supplier) {
        uniforms.uniformMatrixFromArray(UniformUpdateFrequency.PER_FRAME, "shadow" + name, supplier).uniformJomlMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + name + "Inverse", new InvertedArrayMatrix(supplier));
    }

    private static class Inverted
    implements Supplier<Matrix4f> {
        private final Supplier<net.minecraft.util.math.vector.Matrix4f> parent;

        Inverted(Supplier<net.minecraft.util.math.vector.Matrix4f> parent) {
            this.parent = parent;
        }

        @Override
        public Matrix4f get() {
            net.minecraft.util.math.vector.Matrix4f copy = this.parent.get().func_226601_d_();
            FloatBuffer buffer = FloatBuffer.allocate(16);
            copy.func_195879_b(buffer);
            buffer.rewind();
            Matrix4f matrix4f = new Matrix4f(buffer);
            matrix4f.invert();
            return matrix4f;
        }
    }

    private static class Previous
    implements Supplier<net.minecraft.util.math.vector.Matrix4f> {
        private final Supplier<net.minecraft.util.math.vector.Matrix4f> parent;
        private net.minecraft.util.math.vector.Matrix4f previous;

        Previous(Supplier<net.minecraft.util.math.vector.Matrix4f> parent) {
            this.parent = parent;
            this.previous = new net.minecraft.util.math.vector.Matrix4f();
        }

        @Override
        public net.minecraft.util.math.vector.Matrix4f get() {
            net.minecraft.util.math.vector.Matrix4f copy = this.parent.get().func_226601_d_();
            net.minecraft.util.math.vector.Matrix4f previous = this.previous.func_226601_d_();
            this.previous = copy;
            return previous;
        }
    }

    private static class InvertedArrayMatrix
    implements Supplier<Matrix4f> {
        private final Supplier<float[]> parent;

        InvertedArrayMatrix(Supplier<float[]> parent) {
            this.parent = parent;
        }

        @Override
        public Matrix4f get() {
            FloatBuffer buffer = FloatBuffer.allocate(16);
            buffer.put(this.parent.get());
            buffer.rewind();
            Matrix4f matrix4f = new Matrix4f(buffer);
            matrix4f.invert();
            return matrix4f;
        }
    }
}

