/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.stream.IntStream;
import repack.apache.commons.collections4.bloomfilter.BitCountProducer;
import repack.apache.commons.collections4.bloomfilter.BitMap;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;
import repack.apache.commons.collections4.bloomfilter.CountingBloomFilter;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;
import repack.apache.commons.collections4.bloomfilter.Shape;

public final class ArrayCountingBloomFilter
implements CountingBloomFilter {
    private final Shape shape;
    private final int[] counts;
    private int state;

    public ArrayCountingBloomFilter(Shape shape) {
        Objects.requireNonNull(shape, "shape");
        this.shape = shape;
        this.counts = new int[shape.getNumberOfBits()];
    }

    private ArrayCountingBloomFilter(ArrayCountingBloomFilter source) {
        this.shape = source.shape;
        this.state = source.state;
        this.counts = (int[])source.counts.clone();
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
    }

    @Override
    public ArrayCountingBloomFilter copy() {
        return new ArrayCountingBloomFilter(this);
    }

    @Override
    public int characteristics() {
        return 1;
    }

    @Override
    public int cardinality() {
        return (int)IntStream.range(0, this.counts.length).filter(i -> this.counts[i] > 0).count();
    }

    @Override
    public boolean add(BitCountProducer other) {
        Objects.requireNonNull(other, "other");
        other.forEachCount(this::add);
        return this.isValid();
    }

    @Override
    public boolean subtract(BitCountProducer other) {
        Objects.requireNonNull(other, "other");
        other.forEachCount(this::subtract);
        return this.isValid();
    }

    @Override
    public boolean isValid() {
        return this.state >= 0;
    }

    @Override
    public boolean forEachCount(BitCountProducer.BitCountConsumer consumer) {
        Objects.requireNonNull(consumer, "consumer");
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0 || consumer.test(i, this.counts[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachIndex(IntPredicate consumer) {
        Objects.requireNonNull(consumer, "consumer");
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0 || consumer.test(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachBitMap(LongPredicate consumer) {
        long value;
        Objects.requireNonNull(consumer, "consumer");
        int blocksm1 = BitMap.numberOfBitMaps(this.counts.length) - 1;
        int i = 0;
        for (int j = 0; j < blocksm1; ++j) {
            value = 0L;
            for (int k = 0; k < 64; ++k) {
                if (this.counts[i++] == 0) continue;
                value |= BitMap.getLongBit(k);
            }
            if (consumer.test(value)) continue;
            return false;
        }
        value = 0L;
        int k = 0;
        while (i < this.counts.length) {
            if (this.counts[i++] != 0) {
                value |= BitMap.getLongBit(k);
            }
            ++k;
        }
        return consumer.test(value);
    }

    private boolean add(int idx, int addend) {
        int updated = this.counts[idx] + addend;
        this.state |= updated;
        this.counts[idx] = updated;
        return true;
    }

    private boolean subtract(int idx, int subtrahend) {
        int updated = this.counts[idx] - subtrahend;
        this.state |= updated;
        this.counts[idx] = updated;
        return true;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public boolean contains(IndexProducer indexProducer) {
        return indexProducer.forEachIndex(idx -> this.counts[idx] != 0);
    }

    @Override
    public boolean contains(BitMapProducer bitMapProducer) {
        return this.contains(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    @Override
    public int[] asIndexArray() {
        return IntStream.range(0, this.counts.length).filter(i -> this.counts[i] > 0).toArray();
    }
}

