/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;
import repack.apache.commons.collections4.bloomfilter.Hasher;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;
import repack.apache.commons.collections4.bloomfilter.Shape;

public interface BloomFilter
extends IndexProducer,
BitMapProducer {
    public static final int SPARSE = 1;

    public BloomFilter copy();

    public int characteristics();

    public Shape getShape();

    public void clear();

    default public boolean contains(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return (this.characteristics() & 1) != 0 ? this.contains((IndexProducer)other) : this.contains((BitMapProducer)other);
    }

    default public boolean contains(Hasher hasher) {
        Objects.requireNonNull(hasher, "Hasher");
        Shape shape = this.getShape();
        return this.contains(hasher.indices(shape));
    }

    public boolean contains(IndexProducer var1);

    default public boolean contains(BitMapProducer bitMapProducer) {
        return this.forEachBitMapPair(bitMapProducer, (x, y) -> (x & y) == y);
    }

    default public boolean merge(BloomFilter other) {
        return (this.characteristics() & 1) != 0 ? this.merge((IndexProducer)other) : this.merge((BitMapProducer)other);
    }

    default public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.getShape()));
    }

    public boolean merge(IndexProducer var1);

    public boolean merge(BitMapProducer var1);

    default public boolean isFull() {
        return this.cardinality() == this.getShape().getNumberOfBits();
    }

    public int cardinality();

    default public int estimateN() {
        return (int)Math.round(this.getShape().estimateN(this.cardinality()));
    }

    default public int estimateUnion(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        BloomFilter cpy = this.copy();
        cpy.merge(other);
        return cpy.estimateN();
    }

    default public int estimateIntersection(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return this.estimateN() + other.estimateN() - this.estimateUnion(other);
    }
}

