/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import repack.apache.commons.collections4.bloomfilter.BitCountProducer;
import repack.apache.commons.collections4.bloomfilter.BitMapProducer;
import repack.apache.commons.collections4.bloomfilter.BloomFilter;
import repack.apache.commons.collections4.bloomfilter.Hasher;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;

public interface CountingBloomFilter
extends BloomFilter,
BitCountProducer {
    public boolean isValid();

    @Override
    default public boolean merge(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return this.merge((IndexProducer)other);
    }

    @Override
    default public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.uniqueIndices(this.getShape()));
    }

    @Override
    default public boolean merge(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        try {
            return this.add(BitCountProducer.from(indexProducer));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()), e);
        }
    }

    @Override
    default public boolean merge(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        return this.merge(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    default public boolean remove(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return this.remove((IndexProducer)other);
    }

    default public boolean remove(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.remove(hasher.uniqueIndices(this.getShape()));
    }

    default public boolean remove(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        try {
            return this.subtract(BitCountProducer.from(indexProducer));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()));
        }
    }

    default public boolean remove(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        return this.remove(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    public boolean add(BitCountProducer var1);

    public boolean subtract(BitCountProducer var1);

    @Override
    public CountingBloomFilter copy();
}

