/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import repack.apache.commons.collections4.bloomfilter.Hasher;
import repack.apache.commons.collections4.bloomfilter.IndexProducer;
import repack.apache.commons.collections4.bloomfilter.Shape;

public class EnhancedDoubleHasher
implements Hasher {
    private final long initial;
    private final long increment;

    private static long toLong(byte[] byteArray, int offset, int len) {
        long val = 0L;
        int shift = 64;
        int end = offset + Math.min(len, 8);
        for (int i = offset; i < end; ++i) {
            val |= (long)(byteArray[i] & 0xFF) << (shift -= 8);
        }
        return val;
    }

    public EnhancedDoubleHasher(byte[] buffer) {
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer length must be greater than 0");
        }
        int segment = buffer.length / 2;
        this.initial = EnhancedDoubleHasher.toLong(buffer, 0, segment);
        this.increment = EnhancedDoubleHasher.toLong(buffer, segment, buffer.length - segment);
    }

    public EnhancedDoubleHasher(long initial, long increment) {
        this.initial = initial;
        this.increment = increment;
    }

    long getInitial() {
        return this.initial;
    }

    long getIncrement() {
        return this.increment;
    }

    static int mod(long dividend, int divisor) {
        long quotient = (dividend >>> 1) / (long)divisor << 1;
        long remainder = dividend - quotient * (long)divisor;
        return (int)(remainder >= (long)divisor ? remainder - (long)divisor : remainder);
    }

    @Override
    public IndexProducer indices(final Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new IndexProducer(){

            @Override
            public boolean forEachIndex(IntPredicate consumer) {
                Objects.requireNonNull(consumer, "consumer");
                int bits = shape.getNumberOfBits();
                int index = EnhancedDoubleHasher.mod(EnhancedDoubleHasher.this.initial, bits);
                int inc = EnhancedDoubleHasher.mod(EnhancedDoubleHasher.this.increment, bits);
                int k = shape.getNumberOfHashFunctions();
                if (k > bits) {
                    int j = k;
                    while (j > 0) {
                        int block = Math.min(j, bits);
                        j -= block;
                        for (int i = 0; i < block; ++i) {
                            if (!consumer.test(index)) {
                                return false;
                            }
                            index = (index -= inc) < 0 ? index + bits : index;
                            inc = (inc -= i) < 0 ? inc + bits : inc;
                        }
                    }
                } else {
                    for (int i = 0; i < k; ++i) {
                        if (!consumer.test(index)) {
                            return false;
                        }
                        index = (index -= inc) < 0 ? index + bits : index;
                        inc = (inc -= i) < 0 ? inc + bits : inc;
                    }
                }
                return true;
            }

            @Override
            public int[] asIndexArray() {
                int[] result = new int[shape.getNumberOfHashFunctions()];
                int[] idx = new int[1];
                this.forEachIndex(i -> {
                    int n = idx[0];
                    idx[0] = n + 1;
                    result[n] = i;
                    return true;
                });
                return result;
            }
        };
    }
}

