/*
 * Decompiled with CFR 0.152.
 */
package repack.apache.commons.collections4.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import repack.apache.commons.collections4.ResettableIterator;

public class LoopingIterator<E>
implements ResettableIterator<E> {
    private final Collection<? extends E> collection;
    private Iterator<? extends E> iterator;

    public LoopingIterator(Collection<? extends E> collection) {
        this.collection = Objects.requireNonNull(collection, "collection");
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return !this.collection.isEmpty();
    }

    @Override
    public E next() {
        if (this.collection.isEmpty()) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasNext()) {
            this.reset();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void reset() {
        this.iterator = this.collection.iterator();
    }

    public int size() {
        return this.collection.size();
    }
}

