/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PixelmonUpdateEvent;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import fr.reluije.pixeomongocasino.blocks.RouletteMachineBlock;
import fr.reluije.pixeomongocasino.blocks.SlotMachineBlock;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.UpdateStatuePacket;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.EditLotContainer;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import fr.reluije.pixeomongocasino.utils.CustomItemGroup;
import fr.reluije.pixeomongocasino.utils.PGCSounds;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ua.realalpha.pokemonapi.event.PlayerPartySynchronizedEvent;
import ua.realalpha.pokemonapi.event.PlayerPcSynchronizedEvent;

@Mod(value="pixelmongocasino")
public class PixelmonGoCasino {
    public static final String ID = "pixelmongocasino";
    public static final Logger LOGGER = LogManager.getLogger((String)"pixelmongocasino");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pixelmongocasino");
    public static final RegistryObject<Block> BLOCK_SLOT_MACHINE = BLOCKS.register("slot_machine", SlotMachineBlock::new);
    public static final RegistryObject<Block> BLOCK_ROULETTE_MACHINE = BLOCKS.register("roulette_machine", RouletteMachineBlock::new);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pixelmongocasino");
    public static final RegistryObject<Item> ITEM_SLOT_MACHINE = ITEMS.register("slot_machine", () -> new BlockItem((Block)BLOCK_SLOT_MACHINE.get(), new Item.Properties().func_200916_a(CREATIVE_TAB)));
    public static final RegistryObject<Item> ITEM_ROULETTE_MACHINE = ITEMS.register("roulette_machine", () -> new BlockItem((Block)BLOCK_ROULETTE_MACHINE.get(), new Item.Properties().func_200916_a(CREATIVE_TAB)));
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"pixelmongocasino");
    public static final RegistryObject<TileEntityType<SlotMachineTileEntity>> TE_SLOT_MACHINE = TILE_ENTITIES.register("slot_machine", () -> TileEntityType.Builder.func_223042_a(SlotMachineTileEntity::new, (Block[])new Block[]{(Block)BLOCK_SLOT_MACHINE.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<RouletteMachineTileEntity>> TE_ROULETTE_MACHINE = TILE_ENTITIES.register("roulette_machine", () -> TileEntityType.Builder.func_223042_a(RouletteMachineTileEntity::new, (Block[])new Block[]{(Block)BLOCK_ROULETTE_MACHINE.get()}).func_206865_a(null));
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"pixelmongocasino");
    public static final RegistryObject<ContainerType<EditLotContainer>> CONTAINER_ROULETTE_MACHINE = CONTAINERS.register("roulette_machine", () -> IForgeContainerType.create(EditLotContainer::new));
    public static final ItemGroup CREATIVE_TAB = new CustomItemGroup("pixelmongocasino", () -> new ItemStack((IItemProvider)ITEM_SLOT_MACHINE.get()));
    private static final Set<UUID> SYNCHRONIZED_PARTIES = new HashSet<UUID>();
    private static final Set<UUID> SYNCHRONIZED_PC = new HashSet<UUID>();
    private ScorePlayerTeam TEAM_SHINY;
    private ScorePlayerTeam TEAM_LEGENDARY;

    public PixelmonGoCasino() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Pixelmon.EVENT_BUS.register((Object)this);
        Network.init();
        PGCSounds.init();
    }

    @SubscribeEvent
    public void onPixelmonUpdate(PixelmonUpdateEvent event) {
        if (event.pokemon == null || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.TEAM_SHINY == null) {
            this.TEAM_SHINY = new ScorePlayerTeam(event.pokemon.field_70170_p.func_96441_U(), "shiny");
            this.TEAM_SHINY.func_96664_a((ITextComponent)new StringTextComponent("Shiny"));
            this.TEAM_SHINY.func_178774_a(TextFormatting.YELLOW);
            this.TEAM_LEGENDARY = new ScorePlayerTeam(event.pokemon.field_70170_p.func_96441_U(), "legendary");
            this.TEAM_LEGENDARY.func_96664_a((ITextComponent)new StringTextComponent("Legendary"));
            this.TEAM_LEGENDARY.func_178774_a(TextFormatting.RED);
        }
        boolean glow = !event.pokemon.hasOwner() && (event.pokemon.getPokemon().isShiny() || event.pokemon.getPokemon().isLegendary());
        event.pokemon.func_184195_f(glow);
        if (glow && event.pokemon.func_96124_cp() == null) {
            event.pokemon.field_70170_p.func_96441_U().func_197901_a(event.pokemon.func_195047_I_(), event.pokemon.getPokemon().isShiny() ? this.TEAM_SHINY : this.TEAM_LEGENDARY);
        } else if (!glow && event.pokemon.func_96124_cp() != null) {
            event.pokemon.field_70170_p.func_96441_U().func_96512_b(event.pokemon.func_195047_I_(), (ScorePlayerTeam)event.pokemon.func_96124_cp());
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"pokestatue").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"statueId", (ArgumentType)EntityArgument.func_197086_a()).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"pokemon", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)context, (String)"player");
            Entity entity = EntityArgument.func_197088_a((CommandContext)context, (String)"statueId");
            if (entity instanceof StatueEntity) {
                StatueEntity statue = (StatueEntity)entity;
                String pokemon = StringArgumentType.getString((CommandContext)context, (String)"pokemon");
                Network.sendTo(new UpdateStatuePacket(statue.func_145782_y(), pokemon), player);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Entity is not a statue"), false);
            }
            return 1;
        })))))).then(Commands.func_197057_a((String)"tpHere").then(Commands.func_197056_a((String)"statueId", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            Entity entity = EntityArgument.func_197088_a((CommandContext)context, (String)"statueId");
            if (entity instanceof StatueEntity) {
                StatueEntity statue = (StatueEntity)entity;
                statue.func_213373_a(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Entity is not a statue"), false);
            }
            return 1;
        }))));
    }

    @SubscribeEvent
    public void onPartySynchronizedEvent(PlayerPartySynchronizedEvent event) {
        SYNCHRONIZED_PARTIES.add(event.getPlayer().func_110124_au());
        LOGGER.debug("Party synchronized for {}", (Object)event.getPlayer().func_145748_c_().getString());
    }

    @SubscribeEvent
    public void onPCSynchronizedEvent(PlayerPcSynchronizedEvent event) {
        SYNCHRONIZED_PC.add(event.getPlayer().func_110124_au());
        LOGGER.debug("PC synchronized for {}", (Object)event.getPlayer().func_145748_c_().getString());
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity && !living.field_70170_p.field_72995_K && !FMLLoader.isProduction()) {
            SYNCHRONIZED_PC.add(living.func_110124_au());
            SYNCHRONIZED_PARTIES.add(living.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        SYNCHRONIZED_PARTIES.remove(event.getPlayer().func_110124_au());
        SYNCHRONIZED_PC.remove(event.getPlayer().func_110124_au());
    }

    public static boolean isPartySynchronized(UUID playerId) {
        return SYNCHRONIZED_PARTIES.contains(playerId);
    }

    public static boolean isPartySynchronized(PlayerEntity player) {
        return SYNCHRONIZED_PARTIES.contains(player.func_110124_au());
    }

    public static boolean isPCSynchronized(PlayerEntity player) {
        return SYNCHRONIZED_PC.contains(player.func_110124_au());
    }
}

