/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.blocks;

import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import fr.reluije.pixeomongocasino.tileentities.BaseCasinoMachine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public abstract class BaseCasinoMachineBlock
extends ContainerBlock {
    protected static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.01, (double)0.0, (double)0.01, (double)0.99, (double)2.0, (double)0.99);

    protected BaseCasinoMachineBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 0.6f).func_200947_a(SoundType.field_185852_e).harvestLevel(2).harvestTool(ToolType.PICKAXE).func_235861_h_());
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, @Nonnull Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (world.field_72995_K || hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BaseCasinoMachine)) {
            return ActionResultType.FAIL;
        }
        if (!PixelmonGoCasino.isPCSynchronized(player) || !PixelmonGoCasino.isPartySynchronized(player)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.not_synchronized"), true);
            return ActionResultType.SUCCESS;
        }
        BaseCasinoMachine casinoMachine = (BaseCasinoMachine)te;
        if (!casinoMachine.isConfigured() && casinoMachine.isOwner(player)) {
            casinoMachine.openConfigurationMenu(player);
        } else if (casinoMachine.isConfigured() && casinoMachine.isOwner(player) && player.func_225608_bj_() && casinoMachine.canStillConfigured()) {
            casinoMachine.openConfigurationMenu(player);
        } else if (casinoMachine.isConfigured()) {
            casinoMachine.play(player);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BaseCasinoMachine) {
            ((BaseCasinoMachine)te).setOwnerID(entity.func_110124_au());
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        BaseCasinoMachine casinoMachine;
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BaseCasinoMachine && (casinoMachine = (BaseCasinoMachine)te).getOwnerId() != null) {
            if (!player.func_184812_l_() && !casinoMachine.isOwner(player)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.remove.only_owner"), false);
                return false;
            }
            if (world.func_73046_m() == null) {
                return false;
            }
            if (casinoMachine.hasResourceInside()) {
                ServerPlayerEntity owner = world.func_73046_m().func_184103_al().func_177451_a(casinoMachine.getOwnerId());
                if (owner != null && PixelmonGoCasino.isPCSynchronized(player) && PixelmonGoCasino.isPartySynchronized(player)) {
                    casinoMachine.return2Owner((PlayerEntity)owner);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.remove.online_owner"), false);
                    return false;
                }
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public float func_180647_a(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        BaseCasinoMachine casinoMachine;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BaseCasinoMachine && (casinoMachine = (BaseCasinoMachine)te).isOwner(player) && casinoMachine.getSpinningPlayer() == null) {
            return super.func_180647_a(state, player, world, pos);
        }
        return 2.1474836E9f;
    }
}

