/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import fr.reluije.pixeomongocasino.client.CustomPixelmonRenderer;
import fr.reluije.pixeomongocasino.client.OverlayConstants;
import fr.reluije.pixeomongocasino.client.screens.RenderUtil;
import fr.reluije.pixeomongocasino.client.screens.RouletteMachineLotConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.geo.SimpleGeoBlockModel;
import fr.reluije.pixeomongocasino.client.screens.geo.SimpleGeoBlockRenderer;
import fr.reluije.pixeomongocasino.client.utils.ClientItemHelper;
import fr.reluije.pixeomongocasino.client.utils.ClientPixelmonHelper;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.Configuration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.ItemConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.MoneyConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.PokemonConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import fr.reluije.pixeomongocasino.utils.DevSocialInteractionsService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import software.bernie.geckolib3.model.AnimatedGeoModel;

@Mod.EventBusSubscriber(modid="pixelmongocasino", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderText(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult objectMouseOver = mc.field_71476_x;
        if (mc.field_71441_e == null || !(objectMouseOver instanceof BlockRayTraceResult) || mc.field_71462_r != null) {
            return;
        }
        BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)objectMouseOver;
        BlockPos blockPos = blockRayTrace.func_216350_a();
        TileEntity tile = mc.field_71441_e.func_175625_s(blockPos);
        if (tile instanceof SlotMachineTileEntity) {
            try {
                ClientEvents.renderCashMachine(mc, event, (SlotMachineTileEntity)tile);
            }
            catch (Exception e) {
                PixelmonGoCasino.LOGGER.error("Error while rendering SlotMachineTileEntity", (Throwable)e);
            }
        }
    }

    private static void renderCashMachine(Minecraft mc, RenderGameOverlayEvent.Text event, SlotMachineTileEntity cashMachine) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Configuration config = cashMachine.getConfiguration();
        MatrixStack stack = event.getMatrixStack();
        MainWindow window = event.getWindow();
        FontRenderer font = mc.field_71466_p;
        if (cashMachine.isConfigured()) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((float)window.func_198107_o() / 2.0f), (double)((float)window.func_198087_p() / 2.0f - 10.0f), (double)0.0);
            if (config instanceof PokemonConfiguration) {
                RenderSystem.translated((double)-40.0, (double)0.0, (double)0.0);
            }
            RenderUtil.drawFullImage(-75, -75, 150, 150, OverlayConstants.INFOS_BACKGROUND);
            RenderSystem.translated((double)-62.5, (double)-40.0, (double)0.0);
            if (config instanceof PokemonConfiguration) {
                ClientEvents.renderPokemonConfiguration(mc, event, (PokemonConfiguration)config);
            } else if (config instanceof MoneyConfiguration) {
                ClientEvents.renderMoneyConfiguration(mc, event, (MoneyConfiguration)config, cashMachine);
            } else if (config instanceof ItemConfiguration) {
                ClientEvents.renderItemConfiguration(mc, event, (ItemConfiguration)config);
            }
            RenderSystem.translated((double)0.0, (double)32.0, (double)0.0);
            if (ClientPixelmonHelper.getMoney().compareTo(BigDecimal.valueOf(config.getBet())) >= 0) {
                font.getClass();
                font.func_243248_b(stack, (ITextComponent)OverlayConstants.CAN_PLAY, 0.0f, (float)(9 * 6), -16723456);
                font.getClass();
                font.func_243248_b(stack, (ITextComponent)OverlayConstants.CLICK, 0.0f, (float)(9 * 7), OverlayConstants.TEXT_COLOR);
            } else {
                font.getClass();
                font.func_243248_b(stack, (ITextComponent)OverlayConstants.NO_MONEY, 0.0f, (float)(9 * 6), OverlayConstants.TEXT_COLOR);
            }
            RenderSystem.popMatrix();
        } else {
            font.func_243246_a(stack, (ITextComponent)OverlayConstants.NOT_CONFIGURED, (float)(window.func_198107_o() - font.func_238414_a_((ITextProperties)OverlayConstants.NOT_CONFIGURED)) / 2.0f, (float)window.func_198087_p() / 2.0f + 5.0f, -1);
        }
    }

    private static void renderPokemonConfiguration(Minecraft mc, RenderGameOverlayEvent.Text event, PokemonConfiguration config) {
        MatrixStack stack = event.getMatrixStack();
        Pokemon pokemon = config.getPokemon();
        FontRenderer font = mc.field_71466_p;
        if (pokemon != null) {
            int betRequiredLength = font.func_238414_a_((ITextProperties)OverlayConstants.BET_REQUIRED);
            int winChanceLength = font.func_238414_a_((ITextProperties)OverlayConstants.WIN_CHANCE);
            List<String> infos = ClientPixelmonHelper.getInfos(pokemon);
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.BET_REQUIRED, 0.0f, 0.0f, OverlayConstants.TEXT_COLOR);
            font.func_238421_b_(stack, config.getBet() + "$", (float)betRequiredLength, 0.0f, OverlayConstants.TEXT_COLOR);
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.POKEMON, 0.0f, 9.0f, OverlayConstants.TEXT_COLOR);
            ITextComponent iTextComponent = pokemon.getFormattedDisplayName();
            float f = font.func_78256_a("Pok\u00e9mon: ");
            font.getClass();
            font.func_243248_b(stack, iTextComponent, f, 9.0f, OverlayConstants.TEXT_COLOR);
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.WIN_CHANCE, 0.0f, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
            String string = config.getChance() + "%";
            float f2 = winChanceLength;
            font.getClass();
            font.func_238421_b_(stack, string, f2, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
            RenderUtil.drawFullImage(20, 20, 60, 60, pokemon.getSprite());
            int n = infos.size() / 2;
            font.getClass();
            RenderUtil.drawHoveringText(stack, infos, 130, 30 - n * 9);
        }
    }

    private static void renderMoneyConfiguration(Minecraft mc, RenderGameOverlayEvent.Text event, MoneyConfiguration config, SlotMachineTileEntity cashMachine) {
        MatrixStack stack = event.getMatrixStack();
        FontRenderer font = mc.field_71466_p;
        int betRequiredLength = font.func_238414_a_((ITextProperties)OverlayConstants.BET_REQUIRED);
        int winChanceLength = font.func_238414_a_((ITextProperties)OverlayConstants.WIN_CHANCE);
        int multiplierLength = font.func_238414_a_((ITextProperties)OverlayConstants.MULTIPLIER);
        font.func_243248_b(stack, (ITextComponent)OverlayConstants.BET_REQUIRED, 0.0f, 0.0f, OverlayConstants.TEXT_COLOR);
        font.func_238421_b_(stack, config.getBet() + "$", (float)betRequiredLength, 0.0f, OverlayConstants.TEXT_COLOR);
        font.getClass();
        font.func_243248_b(stack, (ITextComponent)OverlayConstants.MULTIPLIER, 0.0f, 9.0f, OverlayConstants.TEXT_COLOR);
        String string = String.valueOf(config.getMultiplier());
        float f = multiplierLength;
        font.getClass();
        font.func_238421_b_(stack, string, f, 9.0f, OverlayConstants.TEXT_COLOR);
        font.getClass();
        font.func_243248_b(stack, (ITextComponent)OverlayConstants.WIN_CHANCE, 0.0f, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
        String string2 = config.getChance() + "%";
        float f2 = winChanceLength;
        font.getClass();
        font.func_238421_b_(stack, string2, f2, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
        if (mc.field_71439_g != null && Objects.equals(cashMachine.getOwnerId(), mc.field_71439_g.func_110124_au())) {
            int bankRemaining = font.func_238414_a_((ITextProperties)OverlayConstants.BANK_REMAINING);
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.BANK_REMAINING, 0.0f, (float)(9 * 6), OverlayConstants.TEXT_COLOR);
            String string3 = config.getBank() + "$";
            float f3 = bankRemaining;
            font.getClass();
            font.func_238421_b_(stack, string3, f3, (float)(9 * 6), OverlayConstants.TEXT_COLOR);
        }
    }

    private static void renderItemConfiguration(Minecraft mc, RenderGameOverlayEvent.Text event, ItemConfiguration config) {
        MatrixStack stack = event.getMatrixStack();
        ItemStack item = config.getItem();
        FontRenderer font = mc.field_71466_p;
        if (item != null && !item.func_190926_b()) {
            int betRequiredLength = font.func_238414_a_((ITextProperties)OverlayConstants.BET_REQUIRED);
            int winChanceLength = font.func_238414_a_((ITextProperties)OverlayConstants.WIN_CHANCE);
            List<String> infos = ClientItemHelper.getInfos(item);
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.BET_REQUIRED, 0.0f, 0.0f, OverlayConstants.TEXT_COLOR);
            font.func_238421_b_(stack, config.getBet() + "$", (float)betRequiredLength, 0.0f, OverlayConstants.TEXT_COLOR);
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.ITEM, 0.0f, 9.0f, OverlayConstants.TEXT_COLOR);
            ITextComponent iTextComponent = item.func_200301_q();
            float f = font.func_78256_a("Item: ");
            font.getClass();
            font.func_243248_b(stack, iTextComponent, f, 9.0f, OverlayConstants.TEXT_COLOR);
            font.getClass();
            font.func_243248_b(stack, (ITextComponent)OverlayConstants.WIN_CHANCE, 0.0f, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
            String string = config.getChance() + "%";
            float f2 = winChanceLength;
            font.getClass();
            font.func_238421_b_(stack, string, f2, (float)(9 * 2), OverlayConstants.TEXT_COLOR);
            RenderUtil.drawItemStack(stack, item, 40, 30, 2.0f);
            int n = infos.size() / 2;
            font.getClass();
            RenderUtil.drawHoveringText(stack, infos, 130, 30 - n * 9);
        }
    }

    @Mod.EventBusSubscriber(modid="pixelmongocasino", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)PixelmonGoCasino.CONTAINER_ROULETTE_MACHINE.get()), RouletteMachineLotConfigScreen::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)PixelmonGoCasino.TE_SLOT_MACHINE.get()), terd -> new SimpleGeoBlockRenderer((TileEntityRendererDispatcher)terd, "pixelmongocasino", "slot_machine"));
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)PixelmonGoCasino.TE_ROULETTE_MACHINE.get()), terd -> new SimpleGeoBlockRenderer<RouletteMachineTileEntity>((TileEntityRendererDispatcher)terd, (AnimatedGeoModel<RouletteMachineTileEntity>)new SimpleGeoBlockModel<RouletteMachineTileEntity>("pixelmongocasino", "roulette_machine"){

                @Override
                public ResourceLocation getTextureLocation(RouletteMachineTileEntity te) {
                    return new ResourceLocation("pixelmongocasino", "textures/block/roulette_machine_" + (te.func_145831_w().func_82737_E() % 5L + 1L) + ".png");
                }
            }));
        }

        @SubscribeEvent
        public static void onInterModEnqueue(InterModEnqueueEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityRegistration.PIXELMON.get()), CustomPixelmonRenderer::new);
            RenderingRegistry.loadEntityRenderers((EntityRendererManager)Minecraft.func_71410_x().func_175598_ae());
        }

        static {
            if (!FMLLoader.isProduction()) {
                Minecraft.func_71410_x().field_244734_au = new DevSocialInteractionsService();
            }
        }
    }
}

