/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import fr.reluije.pixeomongocasino.client.screens.RenderUtil;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import fr.reluije.pixeomongocasino.utils.PGCSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CashMachineBetScreen
extends TexturedScreenBase {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/slot_machine/bet.png");
    private static final List<ItemStack> POSSIBILITIES = Lists.newArrayList((Object[])new ItemStack[]{CashMachineBetScreen.createPokeball("master_ball"), CashMachineBetScreen.createPokeball("ultra_ball"), CashMachineBetScreen.createPokeball("great_ball"), CashMachineBetScreen.createPokeball("premier_ball"), CashMachineBetScreen.createPokeball("love_ball"), CashMachineBetScreen.createPokeball("poke_ball")});
    private static final List<ItemStack> WIN_LINE = Lists.newArrayList((Object[])new ItemStack[]{CashMachineBetScreen.createPokeball("master_ball"), CashMachineBetScreen.createPokeball("master_ball"), CashMachineBetScreen.createPokeball("master_ball")});
    private final SlotMachineTileEntity te;
    private final List<List<ItemStack>> items;

    public CashMachineBetScreen(SlotMachineTileEntity te, boolean win) {
        super("menu.slot_machine.bet.title", 250, 200, BACKGROUND);
        this.te = te;
        this.te.win = win;
        this.items = this.generateItems(win);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new SlideWidget(this, 13, 41, 224, 110, this.te, this.items));
        this.field_230706_i_.field_71439_g.func_213823_a(PGCSounds.SLOT_SPIN, SoundCategory.BLOCKS, 1.0f, 2.0f);
    }

    private List<List<ItemStack>> generateItems(boolean win) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < 15; ++i) {
            ArrayList<ItemStack> itemPossibilities = new ArrayList<ItemStack>(3);
            Collections.shuffle(POSSIBILITIES);
            for (int j = 0; j < 3; ++j) {
                itemPossibilities.add(POSSIBILITIES.get(j));
            }
            items.add(itemPossibilities);
        }
        if (win) {
            items.set(1, WIN_LINE);
        }
        return items;
    }

    private static ItemStack createPokeball(String id) {
        ItemStack pokeball = new ItemStack((IItemProvider)PixelmonItems.poke_ball, 1);
        pokeball.func_196082_o().func_74778_a("PokeBallID", id);
        return pokeball;
    }

    static class SlideWidget
    extends Widget {
        private final SlotMachineTileEntity te;
        private final List<List<ItemStack>> items;
        private boolean isDone = false;

        public SlideWidget(ScreenInterface screen, int x, int y, int width, int height, SlotMachineTileEntity te, List<List<ItemStack>> items) {
            super(screen.getGuiLeft() + x, screen.getGuiTop() + y, width, height, (ITextComponent)new TranslationTextComponent("slide"));
            this.te = te;
            this.items = items;
        }

        public void func_230431_b_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            float xFactor = (float)window.func_198109_k() / (float)window.func_198107_o();
            float yFactor = (float)window.func_198091_l() / (float)window.func_198087_p();
            RenderSystem.pushMatrix();
            RenderSystem.enableScissor((int)((int)((float)this.field_230690_l_ * xFactor)), (int)((int)((float)this.field_230691_m_ * yFactor)), (int)((int)((float)this.field_230688_j_ * xFactor)), (int)((int)((float)this.field_230689_k_ * yFactor)));
            RenderSystem.translated((double)0.0, (double)(128.0 - 40.0 * (double)this.items.size()), (double)0.0);
            RenderSystem.translated((double)this.field_230690_l_, (double)this.field_230691_m_, (double)0.0);
            double[] percents = this.getPercents();
            if (percents[2] == 1.0 && !this.isDone) {
                this.isDone = true;
                if (this.te.win) {
                    Minecraft.func_71410_x().field_71439_g.func_213823_a(PGCSounds.SLOT_WIN, SoundCategory.BLOCKS, 1.0f, 2.0f);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_213823_a(PGCSounds.SLOT_LOSE, SoundCategory.BLOCKS, 1.0f, 2.0f);
                }
            }
            for (int x = 0; x < 3; ++x) {
                double p = percents[x];
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)0.0, (double)(p * 40.0 * (double)(this.items.size() - 3)), (double)0.0);
                for (List<ItemStack> itemStacks : this.items) {
                    ItemStack itemStack = itemStacks.get(x);
                    RenderSystem.pushMatrix();
                    RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
                    RenderUtil.drawItemStack(stack, itemStack, 8 + x * 39, 0);
                    RenderSystem.popMatrix();
                    RenderSystem.translated((double)0.0, (double)40.0, (double)0.0);
                }
                RenderSystem.popMatrix();
            }
            RenderSystem.disableScissor();
            RenderSystem.popMatrix();
        }

        @Nonnull
        private double[] getPercents() {
            double percent = Math.min(1.0, (double)this.te.getAnimationTime() / 4000.0);
            double firstPercent = Math.min(0.3, percent) / 0.3;
            double secondPercent = Math.min(0.4, percent) / 0.4;
            double thirdPercent = Math.min(0.5, percent) / 0.5;
            return new double[]{firstPercent, secondPercent, thirdPercent};
        }
    }
}

