/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import fr.reluije.pixeomongocasino.client.screens.widgets.ButtonWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ItemImageWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.NumberTextField;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.network.ConfigureCashMachinePacket;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class CashMachineItemConfigScreen
extends TexturedScreenBase {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d{0,10}$");
    public static final Pattern CHANCE_PATTERN = Pattern.compile("^\\d{0,3}(?:\\.\\d{0,10})?$");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/slot_machine/pokemon_config.png");
    private final SlotMachineTileEntity te;
    private NumberTextField<Integer> bet;
    private NumberTextField<Double> chance;
    private ItemImageWidget itemImage;
    private List<ItemStack> items;
    private int itemIndex;

    public CashMachineItemConfigScreen(SlotMachineTileEntity te) {
        super("menu.slot_machine.money_config.title", 250, 280, BACKGROUND);
        this.te = te;
        PlayerEntity owner = null;
        for (PlayerEntity pe : te.func_145831_w().func_217369_A()) {
            if (!pe.func_110124_au().equals(te.getOwnerId())) continue;
            owner = pe;
        }
        this.items = owner != null ? CashMachineItemConfigScreen.getPlayerInventoryFirstRow(owner) : Collections.emptyList();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.items != null && !this.items.isEmpty()) {
            this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 59, 90, 20, 20, 0x33FFFFFF).pressHandler(b -> this.updateItem(-1)));
            this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 173, 90, 20, 20, 0x33FFFFFF).pressHandler(b -> this.updateItem(1)));
            this.itemImage = (ItemImageWidget)this.func_230480_a_(new ItemImageWidget((ScreenInterface)this, 92, 66, 68, 68, this.getCurrentItemStack()));
            this.bet = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 56, 168, 140, 18, NUMBER_PATTERN, 0).parser(Integer::parseInt));
            this.chance = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Double>(this, this.field_230712_o_, 56, 200, 140, 18, CHANCE_PATTERN, 0.0).parser(Double::parseDouble).validator(NumberTextField.NumberValidator.clamp(0.0, 100.0)));
            this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 50, 224, 151, 27, 0x22FFFFFF).validator(this::isValidConfiguration).pressHandler(this::saveConfiguration));
        }
    }

    private void updateItem(int modifier) {
        this.itemIndex += modifier;
        if (this.itemIndex >= this.items.size()) {
            this.itemIndex = 0;
        } else if (this.itemIndex < 0) {
            this.itemIndex = this.items.size() - 1;
        }
        this.itemImage.setTexture(this.items.get(this.itemIndex));
    }

    private ItemStack getCurrentItemStack() {
        return this.items.get(this.itemIndex);
    }

    private boolean isValidConfiguration(ButtonWidget button) {
        return this.bet.getValue() >= 0 && this.bet.getValue() < Integer.MAX_VALUE && this.chance.getValue() >= 0.0 && this.chance.getValue() <= 100.0;
    }

    private void saveConfiguration(ButtonWidget button) {
        Network.sendToServer(ConfigureCashMachinePacket.ofItem(this.te.func_174877_v(), this.itemIndex, this.bet.getValue(), this.chance.getValue()));
    }

    public static CompoundNBT itemStackToCompoundNBT(ItemStack stack) {
        CompoundNBT nbt = new CompoundNBT();
        stack.func_77955_b(nbt);
        return nbt;
    }

    public static List<ItemStack> getPlayerInventoryFirstRow(PlayerEntity player) {
        PlayerInventory inventory = player.field_71071_by;
        ArrayList<ItemStack> firstRow = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            firstRow.add(inventory.func_70301_a(i));
        }
        return firstRow;
    }
}

