/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import fr.reluije.pixeomongocasino.client.screens.widgets.ButtonWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.NumberTextField;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.client.utils.ClientPixelmonHelper;
import fr.reluije.pixeomongocasino.network.ConfigureCashMachinePacket;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class CashMachineMoneyConfigScreen
extends TexturedScreenBase {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d{0,10}$");
    public static final Pattern CHANCE_PATTERN = Pattern.compile("^\\d{0,3}(?:\\.\\d{0,10})?$");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/slot_machine/money_config.png");
    private final SlotMachineTileEntity te;
    private NumberTextField<Integer> bank;
    private NumberTextField<Integer> bet;
    private NumberTextField<Integer> multiplier;
    private NumberTextField<Double> chance;

    public CashMachineMoneyConfigScreen(SlotMachineTileEntity te) {
        super("menu.slot_machine.money_config.title", 250, 280, BACKGROUND);
        this.te = te;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.bank = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 56, 70, 140, 18, NUMBER_PATTERN, 0).parser(Integer::parseInt).validator(NumberTextField.NumberValidator.clampWithMap(BigDecimal::valueOf, () -> BigDecimal.ZERO, ClientPixelmonHelper::getMoney)).onValueChanged(i -> this.updateColors()));
        this.bet = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 56, 113, 140, 18, NUMBER_PATTERN, 0).parser(Integer::parseInt).validator(NumberTextField.NumberValidator.clampWithMap(bet -> bet * this.multiplier.getValue(), () -> 0, this.bank::getValue)).onValueChanged(i -> this.updateColors()));
        this.multiplier = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 56, 145, 140, 18, NUMBER_PATTERN, 1).parser(Integer::parseInt).validator(NumberTextField.NumberValidator.clampWithMap(multiplier -> this.bet.getValue() * multiplier, this.bet::getValue, this.bank::getValue)).onValueChanged(i -> this.updateColors()));
        this.chance = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Double>(this, this.field_230712_o_, 56, 188, 140, 18, CHANCE_PATTERN, 0.0).parser(Double::parseDouble).validator(NumberTextField.NumberValidator.clamp(0.0, 100.0)));
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 50, 225, 151, 27, 0x22FFFFFF).validator(this::isValidConfiguration).pressHandler(this::saveConfiguration));
    }

    private void updateColors() {
        this.bank.updateColor();
        this.bet.updateColor();
        this.multiplier.updateColor();
        this.chance.updateColor();
    }

    private boolean isValidConfiguration(ButtonWidget button) {
        int bankValue = this.bank.getValue();
        int betValue = this.bet.getValue();
        int multiplierValue = this.multiplier.getValue();
        double chanceValue = this.chance.getValue();
        if (this.bank.isValueEmpty() || this.bet.isValueEmpty() || this.multiplier.isValueEmpty() || this.chance.isValueEmpty()) {
            return false;
        }
        if (ClientPixelmonHelper.getMoney().compareTo(BigDecimal.valueOf(bankValue)) < 0) {
            return false;
        }
        if ((double)bankValue <= 0.0 || (double)betValue <= 0.0 || (double)multiplierValue <= 0.0) {
            return false;
        }
        if (chanceValue <= 0.0 || chanceValue > 100.0) {
            return false;
        }
        int value = betValue * multiplierValue;
        return value > 0 && value <= bankValue;
    }

    private void saveConfiguration(ButtonWidget button) {
        Network.sendToServer(ConfigureCashMachinePacket.ofMoney(this.te.func_174877_v(), this.bank.getValue(), this.bet.getValue(), this.multiplier.getValue(), this.chance.getValue()));
    }
}

