/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import fr.reluije.pixeomongocasino.client.screens.widgets.ButtonWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ImageWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.NumberTextField;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.network.ConfigureCashMachinePacket;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class CashMachinePokemonConfigScreen
extends TexturedScreenBase {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("^\\d{0,10}$");
    public static final Pattern CHANCE_PATTERN = Pattern.compile("^\\d{0,3}(?:\\.\\d{0,10})?$");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/slot_machine/pokemon_config.png");
    private final SlotMachineTileEntity te;
    private NumberTextField<Integer> bet;
    private NumberTextField<Double> chance;
    private ImageWidget pokemonImage;
    private final List<Pokemon> team;
    private int pokemonIndex;

    public CashMachinePokemonConfigScreen(SlotMachineTileEntity te) {
        super("menu.slot_machine.money_config.title", 250, 280, BACKGROUND);
        this.te = te;
        this.team = ClientStorageManager.party.getTeam();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 59, 90, 20, 20, 0x33FFFFFF).pressHandler(b -> this.updatePokemon(-1)));
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 173, 90, 20, 20, 0x33FFFFFF).pressHandler(b -> this.updatePokemon(1)));
        this.pokemonImage = (ImageWidget)this.func_230480_a_(new ImageWidget((ScreenInterface)this, 92, 66, 68, 68, this.getCurrentPokemonSprite()));
        this.bet = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 56, 168, 140, 18, NUMBER_PATTERN, 0).parser(Integer::parseInt));
        this.chance = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Double>(this, this.field_230712_o_, 56, 200, 140, 18, CHANCE_PATTERN, 0.0).parser(Double::parseDouble).validator(NumberTextField.NumberValidator.clamp(0.0, 100.0)));
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 50, 224, 151, 27, 0x22FFFFFF).validator(this::isValidConfiguration).pressHandler(this::saveConfiguration));
    }

    private void updatePokemon(int modifier) {
        this.pokemonIndex += modifier;
        if (this.pokemonIndex >= this.team.size()) {
            this.pokemonIndex = 0;
        } else if (this.pokemonIndex < 0) {
            this.pokemonIndex = this.team.size() - 1;
        }
        this.pokemonImage.setTexture(this.getCurrentPokemonSprite());
    }

    private Pokemon getCurrentPokemon() {
        return this.team.get(this.pokemonIndex);
    }

    private ResourceLocation getCurrentPokemonSprite() {
        return this.getCurrentPokemon().getSprite();
    }

    private boolean isValidConfiguration(ButtonWidget button) {
        return this.bet.getValue() >= 0 && this.bet.getValue() < Integer.MAX_VALUE && this.chance.getValue() >= 0.0 && this.chance.getValue() <= 100.0;
    }

    private void saveConfiguration(ButtonWidget button) {
        Network.sendToServer(ConfigureCashMachinePacket.ofPokemon(this.te.func_174877_v(), this.getCurrentPokemon(), this.chance.getValue(), this.bet.getValue()));
    }
}

