/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RenderUtil {
    public static void drawFullImage(int x, int y, int width, int height, ResourceLocation texture) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawItemStack(MatrixStack stack, ItemStack itemStack, int x, int y, float scale) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)32.0);
        itemRenderer.field_77023_b = 200.0f;
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        RenderHelper.func_227783_c_();
        itemRenderer.func_180450_b(itemStack, 0, 0);
        RenderSystem.popMatrix();
        itemRenderer.field_77023_b = 0.0f;
    }

    public static void drawItemStack(@Nonnull MatrixStack stack, ItemStack itemStack, int x, int y) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.translated((double)0.0, (double)0.0, (double)32.0);
        itemRenderer.field_77023_b = 200.0f;
        itemRenderer.func_180450_b(itemStack, x, y);
        itemRenderer.field_77023_b = 0.0f;
    }

    public static void drawHoveringText(MatrixStack stack, List<String> lines, int x, int y) {
        if (lines.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int textWidth = lines.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0) + 4;
        int right = x + 12;
        int top = y - 12;
        int height = 8;
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        if (lines.size() > 1) {
            int n = lines.size() - 1;
            font.getClass();
            height += 2 + n * (9 + 1);
        }
        if (right + textWidth > mc.func_228018_at_().func_198107_o()) {
            right -= 28 + textWidth;
        }
        if (top + height + 6 > mc.func_228018_at_().func_198087_p()) {
            top = mc.func_228018_at_().func_198087_p() - height - 6;
        }
        if (top < 4) {
            top += 20;
        }
        int bgColor = -267386864;
        RenderUtil.drawGradientRect(right - 3, top - 4, right + textWidth + 3, top - 3, bgColor, bgColor);
        RenderUtil.drawGradientRect(right - 3, top + height + 3, right + textWidth + 3, top + height + 4, bgColor, bgColor);
        RenderUtil.drawGradientRect(right - 3, top - 3, right + textWidth + 3, top + height + 3, bgColor, bgColor);
        RenderUtil.drawGradientRect(right - 4, top - 3, right - 3, top + height + 3, bgColor, bgColor);
        RenderUtil.drawGradientRect(right + textWidth + 3, top - 3, right + textWidth + 4, top + height + 3, bgColor, bgColor);
        int color1 = 0x505000FF;
        int color2 = (color1 & 0xFEFEFE) >> 1 | color1 & 0xFF000000;
        RenderUtil.drawGradientRect(right - 3, top - 3 + 1, right - 3 + 1, top + height + 3 - 1, color1, color2);
        RenderUtil.drawGradientRect(right + textWidth + 2, top - 3 + 1, right + textWidth + 3, top + height + 3 - 1, color1, color2);
        RenderUtil.drawGradientRect(right - 3, top - 3, right + textWidth + 3, top - 3 + 1, color1, color1);
        RenderUtil.drawGradientRect(right - 3, top + height + 2, right + textWidth + 3, top + height + 3, color2, color2);
        for (String line : lines) {
            font.func_238405_a_(stack, line, (float)right, (float)top, -1);
            font.getClass();
            top += 9 + 1;
        }
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.disableLighting();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.shadeModel((int)7425);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)right, (double)top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, 0.0).func_227885_a_(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_227885_a_(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

