/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.reluije.pixeomongocasino.client.screens.CashMachinePokemonConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.RouletteMachinePriceConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.widgets.ButtonWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ItemImageWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.NumberTextField;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.network.ConfigureRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachineServerPacket;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RouletteMachineMainConfigScreen
extends TexturedScreenBase {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/roulette_machine/configure.png");
    private final RouletteMachineTileEntity te;
    private final List<NumberTextField<Double>> chanceFields = new ArrayList<NumberTextField<Double>>();
    private NumberTextField<Double> totalChanceField;
    private final ITextComponent chanceTitle = new TranslationTextComponent("roulette_machine.chance");
    private final ITextComponent reservingTitle = new TranslationTextComponent("roulette_machine.reserving");

    public RouletteMachineMainConfigScreen(RouletteMachineTileEntity te) {
        super("", 276, 300, BACKGROUND);
        this.te = te;
    }

    @Override
    protected void func_231160_c_() {
        int lot;
        super.func_231160_c_();
        for (lot = 0; lot < 10; ++lot) {
            for (int slot = 0; slot < 10; ++slot) {
                int finalLot = lot;
                this.func_230480_a_(new ItemImageWidget((ScreenInterface)this, (int)(95.0 + Math.floor((float)slot * 17.3f)), (int)(79.0 + Math.floor((float)lot * 17.9f)), 12, 12, this.te.getItem(lot, slot)).scale(0.65f).pressHandler(button -> Network.openRouletteMachineLotEditMenu(this.te.func_174877_v(), OpenRouletteMachineServerPacket.MenuType.LOT, finalLot)));
            }
        }
        for (lot = 0; lot < 10; ++lot) {
            double defaultChance;
            double d = defaultChance = this.hasItemOnLot(lot) ? (double)Math.round(100.0 / (double)this.activeLots()) : 0.0;
            if (this.te.chances != null && this.te.chances.size() > lot && this.te.chances.get(lot) > 0.0) {
                defaultChance = this.te.chances.get(lot);
            }
            this.chanceFields.add((NumberTextField<Double>)this.func_230480_a_((Widget)new NumberTextField<Double>(this, this.field_230712_o_, 50, 80 + lot * 18, 30, 18, CashMachinePokemonConfigScreen.CHANCE_PATTERN, defaultChance).parser(Double::parseDouble).validator(NumberTextField.NumberValidator.clamp(0.1, 100.0))));
        }
        this.totalChanceField = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Double>(this, this.field_230712_o_, 50, 265, 30, 18, CashMachinePokemonConfigScreen.CHANCE_PATTERN, -1.0).parser(Double::parseDouble).validator(value -> this.getTotalChance() == 100.0));
        this.totalChanceField.setReadOnly();
        this.totalChanceField.pressHandler(() -> {
            for (int lot = 0; lot < 10; ++lot) {
                double defaultChance = this.hasItemOnLot(lot) ? (double)Math.round(100.0 / (double)this.activeLots() * 10.0) / 10.0 : 0.0;
                this.chanceFields.get(lot).func_146180_a(String.valueOf(defaultChance));
                this.chanceFields.get(lot).func_146193_g(-16711936);
            }
            double gap = 100.0 - this.getTotalChance();
            for (int lot = 0; lot < 10; ++lot) {
                double value;
                if (!this.hasItemOnLot(lot) || !((value = this.chanceFields.get(lot).getValue().doubleValue()) + gap >= 0.1) || !(value + gap <= 100.0)) continue;
                this.chanceFields.get(lot).func_146180_a(String.valueOf((double)Math.round((value + gap) * 10.0) / 10.0));
                this.chanceFields.get(lot).func_146193_g(-16711936);
                break;
            }
            this.totalChanceField.func_230988_a_(this.field_230706_i_.func_147118_V());
            return false;
        });
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 100, 263, 75, 14, 0x66FFFFFF).pressHandler(buttonWidget -> this.getMinecraft().func_147108_a((Screen)new RouletteMachinePriceConfigScreen(this.te, RouletteMachinePriceConfigScreen.PriceType.CASH))));
        this.func_230480_a_(new ButtonWidget((ScreenInterface)this, 186, 263, 75, 14, 0x66FFFFFF).pressHandler(buttonWidget -> this.getMinecraft().func_147108_a((Screen)new RouletteMachinePriceConfigScreen(this.te, RouletteMachinePriceConfigScreen.PriceType.CREDITS))));
    }

    @Override
    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        stack.func_227860_a_();
        this.field_230712_o_.func_243248_b(stack, this.chanceTitle, 48.0f + (float)this.guiLeft, 65.0f + (float)this.guiTop, 0x404040);
        this.field_230712_o_.func_243248_b(stack, this.reservingTitle, 150.0f + (float)this.guiLeft, 65.0f + (float)this.guiTop, 0x404040);
        stack.func_227865_b_();
    }

    private double getTotalChance() {
        return this.chanceFields.stream().filter(TextFieldWidget::func_212953_l).map(NumberTextField::getValue).mapToDouble(Number::doubleValue).sum();
    }

    private boolean hasItemOnLot(int lot) {
        return !this.te.getItem(lot, 0).func_190926_b();
    }

    private int activeLots() {
        int activeLots = 0;
        for (int i = 0; i < 10; ++i) {
            if (!this.hasItemOnLot(i)) continue;
            ++activeLots;
        }
        return activeLots;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.totalChanceField.func_146180_a(String.valueOf((double)Math.round(this.getTotalChance() * 10.0) / 10.0));
        for (int lot = 0; lot < 10; ++lot) {
            this.chanceFields.get(lot).func_146184_c(this.hasItemOnLot(lot));
        }
    }

    public boolean func_231046_a_(int key, int p_231046_2_, int p_231046_3_) {
        if (key == 256 || key == 257) {
            this.func_231175_as__();
            Network.sendToServer(new ConfigureRouletteMachinePacket(this.te.func_174877_v(), this.te.chances, this.te.betCash, this.te.betCredits));
            return true;
        }
        return super.func_231046_a_(key, p_231046_2_, p_231046_3_);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.te.chances = this.chanceFields.stream().map(NumberTextField::getValue).collect(Collectors.toList());
    }
}

