/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import fr.reluije.pixeomongocasino.client.screens.RenderUtil;
import fr.reluije.pixeomongocasino.client.screens.widgets.ButtonWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ImageWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ItemImageWidget;
import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.client.utils.ClientItemHelper;
import fr.reluije.pixeomongocasino.network.FinishedRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.PlayRouletteMachinePacket;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import fr.reluije.pixeomongocasino.utils.PGCSounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RouletteMachinePlayScreen
extends TexturedScreenBase {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("pixelmongocasino", "textures/guis/roulette_machine/play.png");
    private static final ResourceLocation ARROW = new ResourceLocation("pixelmongocasino", "textures/guis/roulette_machine/arrow.png");
    private final RouletteMachineTileEntity te;
    private final int win;
    private int ticksAfterWin = 0;
    private ImageWidget arrow;
    private List<ItemImageWidget> itemWidgets = new ArrayList<ItemImageWidget>();
    private int lastLot = -1;
    private ITextComponent creditsPrice;
    private ITextComponent cashPrice;

    public RouletteMachinePlayScreen(RouletteMachineTileEntity te, int win) {
        super("", 300, 150, BACKGROUND);
        this.te = te;
        this.win = win;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        List<ItemStack> faceItems = this.te.getFaceItems();
        for (int lot = 9; lot >= 0; --lot) {
            int finalLot = lot;
            this.itemWidgets.add((ItemImageWidget)this.func_230480_a_(new ItemImageWidget((ScreenInterface)this, (int)(26.0 + Math.floor((float)lot * 26.0f)), 74, 16, 16, faceItems.get(lot)).scale(1.0f).tooltipRender((stack, mouseX, mouseY, partialTicks) -> {
                ArrayList<String> lines = new ArrayList<String>();
                if (this.hasItemOnLot(finalLot) && this.win == -1) {
                    lines.add(new TranslationTextComponent("slot_machine.overlay.win_chance").getString() + this.te.chances.get(finalLot) + "%");
                    lines.add("");
                    lines.addAll(ClientItemHelper.getInfos((ItemStack)faceItems.get(finalLot)));
                    stack.func_227861_a_(0.0, 0.0, 500.0);
                    RenderUtil.drawHoveringText(stack, lines, mouseX, mouseY);
                }
            })));
        }
        this.itemWidgets = Lists.reverse(this.itemWidgets);
        ButtonWidget creditsButton = new ButtonWidget((ScreenInterface)this, 50, 111, 81, 16, 0x66FFFFFF).pressHandler(buttonWidget -> Network.sendToServer(new PlayRouletteMachinePacket(this.te.func_174877_v(), RouletteMachineTileEntity.BetType.CREDITS)));
        this.func_230480_a_(creditsButton);
        if (this.te.betCredits <= 0) {
            creditsButton.field_230693_o_ = false;
        }
        ButtonWidget cashButton = new ButtonWidget((ScreenInterface)this, 171, 111, 82, 16, 0x66FFFFFF).pressHandler(buttonWidget -> Network.sendToServer(new PlayRouletteMachinePacket(this.te.func_174877_v(), RouletteMachineTileEntity.BetType.CASH)));
        this.func_230480_a_(cashButton);
        if (this.te.betCash <= 0) {
            cashButton.field_230693_o_ = false;
        }
        this.creditsPrice = new StringTextComponent(this.te.betCredits > 0 ? String.valueOf(this.te.betCredits) : new TranslationTextComponent("slot_machine.overlay.not_available").getString());
        this.cashPrice = new StringTextComponent(this.te.betCash > 0 ? String.valueOf(this.te.betCash) : new TranslationTextComponent("slot_machine.overlay.not_available").getString());
        if (this.win != -1) {
            creditsButton.field_230693_o_ = false;
            cashButton.field_230693_o_ = false;
            this.arrow = new ImageWidget((ScreenInterface)this, 16, 88, 16, 32, ARROW);
            this.func_230480_a_(this.arrow);
            this.te.clientSpinning = true;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.win != -1 && this.ticksAfterWin == 0) {
            int neededX = this.itemWidgets.get((int)this.win).field_230690_l_;
            this.arrow.field_230690_l_ = (int)((double)(this.guiLeft + 16 + 127) + Math.sin((double)this.te.getAnimationTime() * 0.001) * 127.0);
            int gap = Math.abs(this.arrow.field_230690_l_ - neededX);
            if (gap < 5 && !this.te.isSpinning()) {
                this.arrow.field_230690_l_ = neededX;
                this.ticksAfterWin = 1;
                this.te.clientSpinning = false;
                this.field_230706_i_.field_71439_g.func_213823_a(PGCSounds.ROULETTE_WIN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            int currLot = this.itemWidgets.stream().filter(widget -> Math.abs(this.arrow.field_230690_l_ - widget.field_230690_l_) < 5).map(this.itemWidgets::indexOf).findFirst().orElse(-1);
            if (currLot != this.lastLot && currLot != -1) {
                this.lastLot = currLot;
                this.field_230706_i_.field_71439_g.func_213823_a(PGCSounds.ROULETTE_CLICK, SoundCategory.BLOCKS, 1.0f, 2.0f);
            }
        }
        if (this.win != -1 && this.ticksAfterWin >= 1) {
            ++this.ticksAfterWin;
            if (this.ticksAfterWin == 40) {
                Network.sendToServer(new FinishedRouletteMachinePacket(this.te.func_174877_v()));
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.drawGuiContainerBackgroundLayer(stack, mouseX, mouseY, partialTicks);
        stack.func_227860_a_();
        this.field_230712_o_.func_243248_b(stack, this.creditsPrice, (float)(this.guiLeft + 90), (float)(this.guiTop + 118), this.te.betCredits > 0 ? -16711936 : 0x404040);
        this.field_230712_o_.func_243248_b(stack, this.cashPrice, (float)(this.guiLeft + 210), (float)(this.guiTop + 118), this.te.betCash > 0 ? -16711936 : 0x404040);
        stack.func_227865_b_();
    }

    private boolean hasItemOnLot(int lot) {
        return !this.te.getItem(lot, 0).func_190926_b();
    }
}

