/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens;

import fr.reluije.pixeomongocasino.client.screens.CashMachineMoneyConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.widgets.NumberTextField;
import fr.reluije.pixeomongocasino.client.screens.widgets.TexturedScreenBase;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachineServerPacket;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;

public class RouletteMachinePriceConfigScreen
extends TexturedScreenBase {
    private static final ResourceLocation BACKGROUND_CASH = new ResourceLocation("pixelmongocasino", "textures/guis/roulette_machine/cash.png");
    private static final ResourceLocation BACKGROUND_CREDIT = new ResourceLocation("pixelmongocasino", "textures/guis/roulette_machine/credit.png");
    private final RouletteMachineTileEntity te;
    private final PriceType priceType;
    private NumberTextField<Integer> input;

    public RouletteMachinePriceConfigScreen(RouletteMachineTileEntity te, PriceType priceType) {
        super("", 200, 80, priceType == PriceType.CASH ? BACKGROUND_CASH : BACKGROUND_CREDIT);
        this.te = te;
        this.priceType = priceType;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.input = (NumberTextField)this.func_230480_a_((Widget)new NumberTextField<Integer>(this, this.field_230712_o_, 50, 45, 100, 18, CashMachineMoneyConfigScreen.NUMBER_PATTERN, Math.max(0, this.priceType == PriceType.CASH ? this.te.betCash : this.te.betCredits)).parser(Integer::parseInt).validator(NumberTextField.NumberValidator.clamp(1, 1000000)));
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        if (this.priceType == PriceType.CASH) {
            this.te.betCash = this.input.getValue();
        } else {
            this.te.betCredits = this.input.getValue();
        }
        Network.openRouletteMachineLotEditMenu(this.te.func_174877_v(), OpenRouletteMachineServerPacket.MenuType.CONFIG, 0);
    }

    public boolean func_231046_a_(int key, int p_231046_2_, int p_231046_3_) {
        if (key == 257) {
            this.func_231164_f_();
            return true;
        }
        return super.func_231046_a_(key, p_231046_2_, p_231046_3_);
    }

    public static enum PriceType {
        CASH,
        CREDITS;

    }
}

