/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.screens.widgets;

import fr.reluije.pixeomongocasino.client.screens.widgets.ScreenInterface;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NumberTextField<N extends Number>
extends TextFieldWidget {
    private final Pattern pattern;
    private NumberValidator<N> validator;
    private Consumer<N> valueChanged;
    private final N defaultValue;
    private N value;
    private boolean readOnly = false;
    @Nullable
    private PressHandler pressHandler;

    public NumberTextField(ScreenInterface screen, FontRenderer font, int x, int y, int width, int height, Pattern pattern, N defaultValue) {
        super(font, screen.getGuiLeft() + x, screen.getGuiTop() + y, width, height, (ITextComponent)new TranslationTextComponent("number"));
        this.func_146185_a(false);
        this.pattern = pattern;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.func_146180_a(defaultValue.toString());
        this.updateColor();
    }

    public NumberTextField<N> pressHandler(PressHandler pressHandler) {
        this.pressHandler = pressHandler;
        return this;
    }

    public NumberTextField<N> parser(NumberParser<N> parser) {
        this.func_200675_a(str -> {
            if (str.isEmpty()) {
                return true;
            }
            return this.pattern.matcher((CharSequence)str).matches();
        });
        this.func_212954_a(str -> {
            try {
                N newValue;
                N n = newValue = str.isEmpty() ? this.defaultValue : parser.parse((String)str);
                if (((Comparable)newValue).compareTo(this.value) != 0) {
                    this.value = newValue;
                    this.updateColor();
                    if (this.valueChanged != null) {
                        this.valueChanged.accept(newValue);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.func_146193_g(-65536);
                this.value = this.defaultValue;
            }
        });
        return this;
    }

    public NumberTextField<N> validator(NumberValidator<N> validator) {
        this.validator = validator;
        return this;
    }

    public NumberTextField<N> onValueChanged(Consumer<N> valueChanged) {
        this.valueChanged = valueChanged;
        return this;
    }

    public void updateColor() {
        if (this.value != null && this.value.equals(this.defaultValue) && !this.func_230999_j_()) {
            this.func_146193_g(-1996488705);
            return;
        }
        this.func_146193_g(this.validator == null || this.validator.validate(this.value) ? -16711936 : -65536);
    }

    public boolean isValueEmpty() {
        return this.func_146179_b().isEmpty();
    }

    public N getValue() {
        return this.value;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void func_146195_b(boolean focused) {
        if (this.pressHandler != null && focused && !this.pressHandler.onPress()) {
            focused = false;
        }
        if (this.readOnly || !this.func_212953_l()) {
            focused = false;
        }
        super.func_146195_b(focused);
        if (focused && this.func_146179_b().equals(this.defaultValue.toString())) {
            this.func_146180_a("");
        } else if (!focused && this.func_146179_b().isEmpty()) {
            this.func_146180_a(this.defaultValue.toString());
        }
    }

    @FunctionalInterface
    public static interface PressHandler {
        public boolean onPress();
    }

    @FunctionalInterface
    public static interface NumberValidator<N extends Number> {
        public boolean validate(N var1);

        public static <N extends Number> NumberValidator<N> clamp(N min, N max) {
            return value -> ((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0;
        }

        public static <N extends Number, T extends Number> NumberValidator<N> clampWithMap(Function<N, T> map, Supplier<T> min, Supplier<T> max) {
            return value -> {
                Number newValue = (Number)map.apply(value);
                return ((Comparable)((Object)newValue)).compareTo(min.get()) > 0 && ((Comparable)((Object)newValue)).compareTo(max.get()) <= 0;
            };
        }
    }

    @FunctionalInterface
    public static interface NumberParser<N extends Number> {
        public N parse(String var1);
    }
}

