/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.client.utils;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ClientPixelmonHelper {
    private static final String CHAR_COLOR = new String(new char[]{'\u00a7'});

    public static BigDecimal getMoney() {
        return ClientData.playerMoney;
    }

    public static List<String> getInfos(Pokemon pokemon) {
        int i;
        ArrayList list = Lists.newArrayList();
        list.add("&9" + pokemon.getSpecies().getName() + " &8| &eLvl " + pokemon.getPokemonLevel());
        list.add(" ");
        list.add("&eInfo:");
        list.add("&7Nom: &e" + pokemon.getDisplayName());
        Stats baseStats = pokemon.getSpecies().getDefaultForm();
        list.add("&7Type: &9" + ((Element)baseStats.getTypes().get(0)).getName() + " " + (baseStats.getTypes().size() > 1 ? "&7+ &r" + ((Element)baseStats.getTypes().get(1)).getName() : ""));
        list.add("&7Abilit\u00e9s: &e" + pokemon.getAbilityName());
        list.add("&7Genre: &e" + pokemon.getGender().name());
        if (pokemon.getNature() != null) {
            list.add("&7Nature: &e" + pokemon.getNature().name());
        }
        list.add("&7Bonheur: &e" + pokemon.getFriendship());
        if (pokemon.getGrowth() != null) {
            list.add("&7Taille: &e" + pokemon.getGrowth().name());
        }
        list.add("&7Reproductible: &e" + (pokemon.isUnbreedable() ? "&fNon" : "&2Oui"));
        list.add("&7Item retenu: &e" + (pokemon.getHeldItem().func_190926_b() ? "Non" : pokemon.getHeldItem().func_200301_q()));
        list.add(" ");
        list.add("&eStats:");
        PermanentStats stats = pokemon.getStats();
        StringBuilder ivsLine = new StringBuilder();
        StringBuilder evsLine = new StringBuilder();
        BattleStatsType[] statValues = BattleStatsType.values();
        for (i = 0; i < statValues.length; ++i) {
            BattleStatsType statValue = statValues[i];
            if (i != 0) {
                evsLine.append(" / ");
                ivsLine.append(" / ");
            }
            evsLine.append(stats.getEVs().getStat(statValue));
            ivsLine.append(stats.getIVs().getStat(statValue));
        }
        list.add("&7IVs: " + ivsLine);
        list.add("&7EVs: " + evsLine);
        list.add("&7Dynamax Level: &f" + pokemon.getDynamaxLevel());
        list.add(" ");
        list.add("&eCapacit\u00e9s:");
        for (i = 0; i < pokemon.getMoveset().size(); ++i) {
            list.add("&7 - " + pokemon.getMoveset().get(i).getMove().getAttackName());
        }
        list.replaceAll(s -> s.replace("&", CHAR_COLOR));
        return list;
    }
}

