/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ConfigureCashMachinePacket {
    public static final byte POKEMON = 1;
    public static final byte MONEY = 2;
    public static final byte ITEM = 3;
    private final byte type;
    private final BlockPos position;
    private final double chance;
    private final UUID pokemonId;
    private final int bank;
    private final int bet;
    private final int multiplier;
    private final int slotItem;

    private ConfigureCashMachinePacket(byte type, BlockPos position, double chance, int bet, UUID pokemonId, int bank, int multiplier, int slotItem) {
        this.position = position;
        this.type = type;
        this.chance = chance;
        this.pokemonId = pokemonId;
        this.bank = bank;
        this.bet = bet;
        this.multiplier = multiplier;
        this.slotItem = slotItem;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.position);
        buffer.writeByte((int)this.type);
        buffer.writeDouble(this.chance);
        switch (this.type) {
            case 1: {
                buffer.func_150787_b(this.bet);
                buffer.func_179252_a(this.pokemonId);
                break;
            }
            case 2: {
                buffer.func_150787_b(this.bank);
                buffer.func_150787_b(this.bet);
                buffer.func_150787_b(this.multiplier);
                break;
            }
            case 3: {
                buffer.func_150787_b(this.bet);
                buffer.func_150787_b(this.slotItem);
            }
        }
    }

    public static ConfigureCashMachinePacket read(PacketBuffer buffer) {
        BlockPos position = buffer.func_179259_c();
        byte type = buffer.readByte();
        double chance = buffer.readDouble();
        UUID pokemonId = null;
        int bank = 0;
        int bet = 0;
        int multiplier = 0;
        int slotItem = 0;
        switch (type) {
            case 1: {
                bet = buffer.func_150792_a();
                pokemonId = buffer.func_179253_g();
                break;
            }
            case 2: {
                bank = buffer.func_150792_a();
                bet = buffer.func_150792_a();
                multiplier = buffer.func_150792_a();
                break;
            }
            case 3: {
                bet = buffer.func_150792_a();
                slotItem = buffer.func_150792_a();
            }
        }
        return new ConfigureCashMachinePacket(type, position, chance, bet, pokemonId, bank, multiplier, slotItem);
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            assert (player != null);
            TileEntity tile = player.field_70170_p.func_175625_s(this.position);
            if (!(tile instanceof SlotMachineTileEntity)) {
                return;
            }
            SlotMachineTileEntity cashMachine = (SlotMachineTileEntity)tile;
            switch (this.type) {
                case 1: {
                    cashMachine.setPokemonConfiguration((PlayerEntity)player, this.chance, this.bet, this.pokemonId);
                    break;
                }
                case 2: {
                    cashMachine.setMoneyConfiguration((PlayerEntity)player, this.chance, this.bet, this.bank, this.multiplier);
                    break;
                }
                case 3: {
                    cashMachine.setItemConfiguration((PlayerEntity)player, this.chance, this.bet, this.slotItem);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static ConfigureCashMachinePacket ofPokemon(BlockPos position, Pokemon pokemon, double chance, int bet) {
        return new ConfigureCashMachinePacket(1, position, chance, bet, pokemon.getUUID(), 0, 0, 0);
    }

    public static ConfigureCashMachinePacket ofMoney(BlockPos position, int bank, int bet, int multiplier, double chance) {
        return new ConfigureCashMachinePacket(2, position, chance, bet, null, bank, multiplier, 0);
    }

    public static ConfigureCashMachinePacket ofItem(BlockPos position, int slotItem, int bet, double chance) {
        return new ConfigureCashMachinePacket(3, position, chance, bet, null, 0, 0, slotItem);
    }
}

