/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ConfigureRouletteMachinePacket {
    private final BlockPos position;
    private final List<Double> chances;
    private final int betCash;
    private final int betCredits;

    public ConfigureRouletteMachinePacket(BlockPos position, List<Double> chances, int betCash, int betCredits) {
        this.position = position;
        this.chances = chances;
        this.betCash = betCash;
        this.betCredits = betCredits;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.position);
        buffer.func_150787_b(this.chances.size());
        for (double chance : this.chances) {
            buffer.writeDouble(chance);
        }
        buffer.func_150787_b(this.betCash);
        buffer.func_150787_b(this.betCredits);
    }

    public static ConfigureRouletteMachinePacket read(PacketBuffer buffer) {
        BlockPos position = buffer.func_179259_c();
        int size = buffer.func_150792_a();
        ArrayList<Double> chances = new ArrayList<Double>();
        for (int i = 0; i < size; ++i) {
            chances.add(buffer.readDouble());
        }
        int betCash = buffer.func_150792_a();
        int betCredits = buffer.func_150792_a();
        return new ConfigureRouletteMachinePacket(position, chances, betCash, betCredits);
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            assert (player != null);
            TileEntity te = player.field_70170_p.func_175625_s(this.position);
            if (!(te instanceof RouletteMachineTileEntity)) {
                return;
            }
            RouletteMachineTileEntity rouletteMachine = (RouletteMachineTileEntity)te;
            rouletteMachine.configure((PlayerEntity)player, this.chances, this.betCash, this.betCredits);
        });
        ctx.setPacketHandled(true);
    }
}

