/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.network.ConfigureCashMachinePacket;
import fr.reluije.pixeomongocasino.network.ConfigureRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.FinishedRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachineServerPacket;
import fr.reluije.pixeomongocasino.network.OpenSlotMachinePacket;
import fr.reluije.pixeomongocasino.network.PlayAnimationPacket;
import fr.reluije.pixeomongocasino.network.PlayRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.UpdateStatuePacket;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class Network {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("pixelmongocasino", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        int id = 0;
        CHANNEL.registerMessage(id++, OpenSlotMachinePacket.class, OpenSlotMachinePacket::write, OpenSlotMachinePacket::read, OpenSlotMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, ConfigureCashMachinePacket.class, ConfigureCashMachinePacket::write, ConfigureCashMachinePacket::read, ConfigureCashMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, PlayAnimationPacket.class, PlayAnimationPacket::write, PlayAnimationPacket::read, PlayAnimationPacket::process, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, OpenRouletteMachinePacket.class, OpenRouletteMachinePacket::write, OpenRouletteMachinePacket::read, OpenRouletteMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        CHANNEL.registerMessage(id++, OpenRouletteMachineServerPacket.class, OpenRouletteMachineServerPacket::write, OpenRouletteMachineServerPacket::read, OpenRouletteMachineServerPacket::process, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, ConfigureRouletteMachinePacket.class, ConfigureRouletteMachinePacket::write, ConfigureRouletteMachinePacket::read, ConfigureRouletteMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, PlayRouletteMachinePacket.class, PlayRouletteMachinePacket::write, PlayRouletteMachinePacket::read, PlayRouletteMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, FinishedRouletteMachinePacket.class, FinishedRouletteMachinePacket::write, FinishedRouletteMachinePacket::read, FinishedRouletteMachinePacket::process, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL.registerMessage(id++, UpdateStatuePacket.class, UpdateStatuePacket::write, UpdateStatuePacket::read, UpdateStatuePacket::process, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void openRouletteMachineLotEditMenu(BlockPos pos, OpenRouletteMachineServerPacket.MenuType type, int lot) {
        CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new OpenRouletteMachineServerPacket(pos, type, lot));
    }

    public static void openRouletteMachineMenu(PlayerEntity player, BlockPos pos, OpenRouletteMachinePacket.MenuType type, int winIndex) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new IllegalArgumentException("player must be a ServerPlayerEntity");
        }
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OpenRouletteMachinePacket(pos, type, winIndex));
    }

    public static void openCashMachineMenu(PlayerEntity player, BlockPos pos, OpenSlotMachinePacket.MenuType type, boolean win) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new IllegalArgumentException("player must be a ServerPlayerEntity");
        }
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OpenSlotMachinePacket(pos, type, win));
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    public static void sendToAllAround(Object packet, BlockPos pos, World world, double radius) {
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), radius, world.func_234923_W_());
        CHANNEL.send(PacketDistributor.NEAR.with(() -> point), packet);
    }

    public static void sendTo(Object packet, ServerPlayerEntity player) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

