/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.network.client.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenRouletteMachinePacket {
    private final BlockPos pos;
    private final MenuType type;
    private final int winIndex;

    public OpenRouletteMachinePacket(BlockPos pos, MenuType type, int winIndex) {
        this.pos = pos;
        this.type = type;
        this.winIndex = winIndex;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.winIndex);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleOpenRouletteMachine(this));
        ctx.get().setPacketHandled(true);
    }

    public MenuType getType() {
        return this.type;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getWinIndex() {
        return this.winIndex;
    }

    public static OpenRouletteMachinePacket read(PacketBuffer buffer) {
        MenuType type = (MenuType)buffer.func_179257_a(MenuType.class);
        BlockPos position = buffer.func_179259_c();
        int winIndex = buffer.readInt();
        return new OpenRouletteMachinePacket(position, type, winIndex);
    }

    public static enum MenuType {
        CONFIG,
        BET;

    }
}

