/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenRouletteMachineServerPacket {
    private final BlockPos pos;
    private final MenuType type;
    private final int lot;

    public OpenRouletteMachineServerPacket(BlockPos pos, MenuType type, int lot) {
        this.pos = pos;
        this.type = type;
        this.lot = lot;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.lot);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_175625_s(this.pos);
            if (!(te instanceof RouletteMachineTileEntity)) {
                return;
            }
            RouletteMachineTileEntity rouletteMachine = (RouletteMachineTileEntity)te;
            if (rouletteMachine.isOwner((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender())) {
                if (this.type == MenuType.LOT) {
                    rouletteMachine.openEditLotScreen(((NetworkEvent.Context)ctx.get()).getSender(), this.lot);
                } else if (this.type == MenuType.CONFIG) {
                    rouletteMachine.openConfigurationMenu((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static OpenRouletteMachineServerPacket read(PacketBuffer buffer) {
        MenuType type = (MenuType)buffer.func_179257_a(MenuType.class);
        BlockPos position = buffer.func_179259_c();
        int winIndex = buffer.readInt();
        return new OpenRouletteMachineServerPacket(position, type, winIndex);
    }

    public static enum MenuType {
        CONFIG,
        LOT;

    }
}

