/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.network.client.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenSlotMachinePacket {
    private final BlockPos position;
    private final MenuType type;
    private final boolean win;

    public OpenSlotMachinePacket(BlockPos position, MenuType type, boolean win) {
        this.position = position;
        this.type = type;
        this.win = win;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        buffer.func_179255_a(this.position);
        buffer.writeBoolean(this.win);
    }

    public void process(Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleOpenSlotMachine(this));
        ctx.get().setPacketHandled(true);
    }

    public MenuType getType() {
        return this.type;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public boolean isWin() {
        return this.win;
    }

    public static OpenSlotMachinePacket read(PacketBuffer buffer) {
        MenuType type = (MenuType)buffer.func_179257_a(MenuType.class);
        BlockPos position = buffer.func_179259_c();
        boolean win = buffer.readBoolean();
        return new OpenSlotMachinePacket(position, type, win);
    }

    public static enum MenuType {
        CONFIG,
        BET;

    }
}

