/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network;

import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayRouletteMachinePacket {
    private final BlockPos position;
    private final RouletteMachineTileEntity.BetType betType;

    public PlayRouletteMachinePacket(BlockPos position, RouletteMachineTileEntity.BetType betType) {
        this.position = position;
        this.betType = betType;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.position);
        buffer.func_179249_a((Enum)this.betType);
    }

    public static PlayRouletteMachinePacket read(PacketBuffer buffer) {
        BlockPos position = buffer.func_179259_c();
        RouletteMachineTileEntity.BetType betType = (RouletteMachineTileEntity.BetType)buffer.func_179257_a(RouletteMachineTileEntity.BetType.class);
        return new PlayRouletteMachinePacket(position, betType);
    }

    public void process(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            assert (player != null);
            TileEntity te = player.field_70170_p.func_175625_s(this.position);
            if (!(te instanceof RouletteMachineTileEntity)) {
                return;
            }
            RouletteMachineTileEntity rouletteMachine = (RouletteMachineTileEntity)te;
            if (rouletteMachine.clientSpinning) {
                rouletteMachine.clientSpinning = false;
                return;
            }
            rouletteMachine.play((PlayerEntity)player, this.betType);
        });
        ctx.setPacketHandled(true);
    }
}

