/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.network.client;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import fr.reluije.pixeomongocasino.client.screens.CashMachineBetScreen;
import fr.reluije.pixeomongocasino.client.screens.CashMachineMainConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.RouletteMachineMainConfigScreen;
import fr.reluije.pixeomongocasino.client.screens.RouletteMachinePlayScreen;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.OpenSlotMachinePacket;
import fr.reluije.pixeomongocasino.network.PlayAnimationPacket;
import fr.reluije.pixeomongocasino.network.UpdateStatuePacket;
import fr.reluije.pixeomongocasino.tileentities.BaseCasinoMachine;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.RouletteMachineTileEntity;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.SlotMachineTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;

public class ClientPacketHandler {
    public static void handleOpenSlotMachine(OpenSlotMachinePacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        assert (mc.field_71439_g != null);
        TileEntity te = mc.field_71439_g.field_70170_p.func_175625_s(packet.getPosition());
        if (!(te instanceof SlotMachineTileEntity)) {
            return;
        }
        SlotMachineTileEntity cashMachine = (SlotMachineTileEntity)te;
        if (packet.getType() == OpenSlotMachinePacket.MenuType.CONFIG && cashMachine.isOwner((PlayerEntity)mc.field_71439_g)) {
            mc.func_147108_a((Screen)new CashMachineMainConfigScreen(cashMachine));
        } else if (packet.getType() == OpenSlotMachinePacket.MenuType.BET && cashMachine.isConfigured()) {
            mc.func_147108_a((Screen)new CashMachineBetScreen(cashMachine, packet.isWin()));
        }
    }

    public static void handlePlayAnimation(PlayAnimationPacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        TileEntity te = world.func_175625_s(packet.getPosition());
        if (te instanceof BaseCasinoMachine) {
            ((BaseCasinoMachine)te).startAnimation();
        }
    }

    public static void handleOpenRouletteMachine(OpenRouletteMachinePacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        assert (mc.field_71439_g != null);
        TileEntity te = mc.field_71439_g.field_70170_p.func_175625_s(packet.getPos());
        if (!(te instanceof RouletteMachineTileEntity)) {
            return;
        }
        RouletteMachineTileEntity rouletteMachine = (RouletteMachineTileEntity)te;
        if (packet.getType() == OpenRouletteMachinePacket.MenuType.CONFIG && rouletteMachine.isOwner((PlayerEntity)mc.field_71439_g)) {
            mc.func_147108_a((Screen)new RouletteMachineMainConfigScreen(rouletteMachine));
        } else if (packet.getType() == OpenRouletteMachinePacket.MenuType.BET && rouletteMachine.isConfigured()) {
            mc.func_147108_a((Screen)new RouletteMachinePlayScreen(rouletteMachine, packet.getWinIndex()));
        }
    }

    public static void handleUpdateStatue(UpdateStatuePacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        assert (mc.field_71439_g != null);
        StatueEntity statue = (StatueEntity)mc.field_71439_g.field_70170_p.func_73045_a(packet.entityId);
        if (statue != null) {
            PokemonSpecification spec = PokemonSpecificationProxy.create((String[])new String[]{packet.text});
            if (!spec.getValue(SpeciesRequirement.class).isPresent()) {
                return;
            }
            Pokemon pokemon = spec.create();
            if (pokemon != null) {
                statue.setPokemon(pokemon);
            }
        }
    }
}

