/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.roulette_machine;

import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.OpenRouletteMachinePacket;
import fr.reluije.pixeomongocasino.network.PlayAnimationPacket;
import fr.reluije.pixeomongocasino.tileentities.BaseCasinoMachine;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.EditLotContainer;
import fr.reluije.pixeomongocasino.tileentities.roulette_machine.SortedInventory;
import fr.reluije.pixeomongocasino.utils.ServerPixelmonHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import ua.realalpha.pokemonapi.PokemonSyncApi;
import ua.realalpha.pokemonapi.RabbitMqPacketBridge;

public class RouletteMachineTileEntity
extends BaseCasinoMachine
implements INamedContainerProvider {
    public static final long SPINNING_LENGTH = 4000L;
    private int win;
    private PlayerEntity spinningPlayer;
    private long animationStart = -1L;
    private int waitingCash;
    private int waitingPoints;
    private final SortedInventory inventory = new SortedInventory(100);
    public List<Double> chances = null;
    public int betCash;
    public int betCredits;
    private int initialFilledSlots;
    public boolean clientSpinning;

    public RouletteMachineTileEntity() {
        super((TileEntityType<? extends BaseCasinoMachine>)((TileEntityType)PixelmonGoCasino.TE_ROULETTE_MACHINE.get()));
    }

    @Override
    public PlayerEntity getSpinningPlayer() {
        return this.spinningPlayer;
    }

    public List<ItemStack> getFaceItems() {
        ArrayList<ItemStack> faceItems = new ArrayList<ItemStack>();
        for (int lot = 0; lot < 10; ++lot) {
            faceItems.add(this.getItem(lot, 0).func_77946_l());
            ((ItemStack)faceItems.get(faceItems.size() - 1)).func_190920_e(1);
        }
        return faceItems;
    }

    public int getRandomWinIndex() {
        double total = this.chances.stream().reduce(0.0, Double::sum);
        double random = Math.random() * total;
        double sum = 0.0;
        for (int i = 0; i < this.chances.size(); ++i) {
            if (!(random < (sum += this.chances.get(i).doubleValue()))) continue;
            return i;
        }
        throw new IllegalStateException("Invalid chances");
    }

    public void give(PlayerEntity player, int index) {
        ItemStack itemStack = this.getItem(index, 0);
        ItemStack itemStack1 = itemStack.func_77946_l();
        itemStack1.func_190920_e(1);
        if (!player.field_71071_by.func_70441_a(itemStack1)) {
            player.func_71019_a(itemStack1, false);
        }
        itemStack.func_190918_g(1);
        this.updateItems();
    }

    private void updateItems() {
        for (int lot = 0; lot < 10; ++lot) {
            for (int slot = 1; slot < 10; ++slot) {
                int i = lot * 10 + slot;
                if (!this.inventory.func_70301_a(i - 1).func_190926_b() || this.inventory.func_70301_a(i).func_190926_b()) continue;
                this.inventory.func_70299_a(i - 1, this.inventory.func_70301_a(i));
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    public boolean check(PlayerEntity player, BetType betType) {
        if (betType == BetType.CASH) {
            return ServerPixelmonHelper.getMoney(player).compareTo(BigDecimal.valueOf(this.betCash)) >= 0;
        }
        if (betType == BetType.CREDITS) {
            return ServerPixelmonHelper.getCredits(player) >= (long)this.betCredits;
        }
        return false;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canRun() {
        return this.isConfigured() && this.isValid();
    }

    public int getFilledLots() {
        int filledLots = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.inventory.func_70301_a(i * 10).func_190926_b()) continue;
            ++filledLots;
        }
        return filledLots;
    }

    public boolean isValid() {
        int f = this.getFilledLots();
        return f >= 2 && this.chances != null && (long)f == this.chances.stream().filter(d -> d > 0.0).count() && f == this.initialFilledSlots && (float)Math.round(this.chances.stream().reduce(0.0, Double::sum)) == 100.0f && (this.betCash > 0 || this.betCredits > 0);
    }

    public void configure(PlayerEntity player, List<Double> chances, int betCash, int betPoints) {
        if (this.getFilledLots() < 2) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("roulette_machine.not_enough_lots"), false);
            return;
        }
        if (betCash <= 0 && betPoints <= 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("roulette_machine.invalid_bet"), false);
            return;
        }
        if (betCash <= 0 && betPoints > 0) {
            betCash = -1;
        } else if (betCash > 0 && betPoints <= 0) {
            betPoints = -1;
        }
        for (int lot = 0; lot < 10; ++lot) {
            if (this.getItem(lot, 0).func_190926_b()) {
                chances.set(lot, 0.0);
                continue;
            }
            if (chances.get(lot) < 0.1 || chances.get(lot) > 100.0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("roulette_machine.invalid_chance"), false);
                return;
            }
            if (chances.get(lot) != 0.0) continue;
            return;
        }
        if ((float)Math.round(chances.stream().reduce(0.0, Double::sum)) != 100.0f) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("roulette_machine.invalid_total_chance"), false);
            return;
        }
        this.chances = chances;
        this.betCash = betCash;
        this.betCredits = betPoints;
        this.initialFilledSlots = this.getFilledLots();
        player.func_71053_j();
        this.updateItems();
        this.sync();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("roulette_machine.configured"), false);
    }

    @Override
    public void startAnimation() {
        this.animationStart = System.currentTimeMillis();
    }

    public long getAnimationTime() {
        return System.currentTimeMillis() - this.animationStart;
    }

    @Override
    public boolean isConfigured() {
        return !this.inventory.func_191420_l() && this.chances != null && (this.betCash > 0 || this.betCredits > 0);
    }

    @Override
    public boolean hasResourceInside() {
        return !this.inventory.func_191420_l() || this.waitingCash > 0 || this.waitingPoints > 0;
    }

    @Override
    public void openConfigurationMenu(PlayerEntity player) {
        Network.openRouletteMachineMenu(player, this.func_174877_v(), OpenRouletteMachinePacket.MenuType.CONFIG, 0);
    }

    public void openEditLotScreen(ServerPlayerEntity player, int lot) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerEntity) -> new EditLotContainer(id, playerInventory, this, lot), (ITextComponent)new TranslationTextComponent("menu.roulette_machine.edit_lot", new Object[]{lot + 1})), buf -> {
            buf.func_179255_a(this.field_174879_c);
            buf.writeInt(lot);
        });
    }

    public boolean isSpinning() {
        return this.animationStart > 0L && System.currentTimeMillis() - this.animationStart < 4000L;
    }

    @Override
    public void play(PlayerEntity player) {
        if (!this.canRun()) {
            if (this.isOwner(player)) {
                this.openConfigurationMenu(player);
                return;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.cannot_run"), false);
            return;
        }
        Network.openRouletteMachineMenu(player, this.field_174879_c, OpenRouletteMachinePacket.MenuType.BET, -1);
    }

    public void play(PlayerEntity player, BetType betType) {
        if (this.func_145831_w() == null) {
            throw new IllegalStateException("No world");
        }
        if (this.isSpinning()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.already_running"), false);
            return;
        }
        if (!this.canRun()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.cannot_run"), false);
            return;
        }
        if (!this.check(player, betType)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.not_enough_money"), false);
            return;
        }
        if (betType == BetType.CASH) {
            ServerPixelmonHelper.changeMoney(player, BigDecimal.valueOf(this.betCash).negate());
            ServerPixelmonHelper.changeMoney(this.ownerId, BigDecimal.valueOf(this.betCash));
            PokemonSyncApi pokemonSyncApi = PokemonSyncApi.getInstance();
            RabbitMqPacketBridge rabbitMqPacketBridge = pokemonSyncApi.getRabbitMqPacketBridge();
            rabbitMqPacketBridge.sendMessage(this.ownerId, "\u00a77[\u00a7a+\u00a77] \u00a7fVous avez gagn\u00e9 \u00a7a+" + this.betCash + "\u00a7f gr\u00e2ce au joueur " + player.func_200200_C_().getString() + " \u00e0 votre Casino.");
        } else if (betType == BetType.CREDITS) {
            ServerPixelmonHelper.changeCredits(player, -this.betCredits);
            this.waitingPoints += this.betCredits;
        }
        this.win = this.getRandomWinIndex();
        this.spinningPlayer = player;
        this.clientSpinning = true;
        this.startAnimation();
        this.sync();
        Network.sendToAllAround(new PlayAnimationPacket(this.field_174879_c), this.field_174879_c, this.func_145831_w(), 32.0);
        Network.openRouletteMachineMenu(player, this.field_174879_c, OpenRouletteMachinePacket.MenuType.BET, this.win);
    }

    @Override
    public void return2Owner(PlayerEntity owner) {
        for (int i = 0; i < 100; ++i) {
            ItemStack itemStack = this.inventory.func_70301_a(i);
            if (owner.field_71071_by.func_70441_a(itemStack)) continue;
            owner.func_71019_a(itemStack, false);
        }
        this.inventory.func_174888_l();
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world == null || world.func_201670_d() || world.func_73046_m() == null || this.ownerId == null) {
            return;
        }
        if (this.spinningPlayer != null && this.animationStart > 0L && this.canRun() && (!this.clientSpinning || this.animationStart <= 0L || System.currentTimeMillis() - this.animationStart >= 16000L)) {
            this.give(this.spinningPlayer, this.win);
            this.spinningPlayer.func_71053_j();
            this.animationStart = -1L;
            this.spinningPlayer = null;
            this.clientSpinning = false;
            this.win = -1;
            this.sync();
        }
        if (this.ownerId != null && PixelmonGoCasino.isPartySynchronized(this.ownerId)) {
            ServerPlayerEntity owner;
            if (this.waitingCash > 0) {
                ServerPlayerEntity owner2 = world.func_73046_m().func_184103_al().func_177451_a(this.ownerId);
                if (owner2 != null) {
                    ServerPixelmonHelper.changeMoney((PlayerEntity)owner2, BigDecimal.valueOf(this.waitingCash));
                    this.waitingCash = 0;
                }
            } else if (this.waitingPoints > 0 && (owner = world.func_73046_m().func_184103_al().func_177451_a(this.ownerId)) != null) {
                ServerPixelmonHelper.changeCredits((PlayerEntity)owner, this.waitingPoints);
                this.waitingPoints = 0;
            }
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.chances != null) {
            ListNBT chancesNBT = new ListNBT();
            for (Double chance : this.chances) {
                chancesNBT.add((Object)DoubleNBT.func_229684_a_((double)chance));
            }
            nbt.func_218657_a("Chances", (INBT)chancesNBT);
        }
        nbt.func_74768_a("BetCash", this.betCash);
        nbt.func_74768_a("BetCredits", this.betCredits);
        nbt.func_218657_a("Inventory", (INBT)this.inventory.func_70487_g());
        nbt.func_74768_a("WaitingCash", this.waitingCash);
        nbt.func_74768_a("WaitingPoints", this.waitingPoints);
        nbt.func_74768_a("InitialFilledSlots", this.initialFilledSlots);
        return nbt;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("Chances")) {
            ListNBT chancesNBT = nbt.func_150295_c("Chances", 6);
            this.chances = new ArrayList<Double>();
            for (int i = 0; i < chancesNBT.size(); ++i) {
                this.chances.add(chancesNBT.func_150309_d(i));
            }
        } else {
            this.chances = null;
        }
        this.betCash = nbt.func_74762_e("BetCash");
        this.betCredits = nbt.func_74762_e("BetCredits");
        this.inventory.func_70486_a(nbt.func_150295_c("Inventory", 10));
        this.waitingCash = nbt.func_74762_e("WaitingCash");
        this.waitingPoints = nbt.func_74762_e("WaitingPoints");
        this.initialFilledSlots = nbt.func_74762_e("InitialFilledSlots");
    }

    @Override
    public boolean canStillConfigured() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("menu.roulette_machine.title");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new EditLotContainer(id, playerInventory, this, 1);
    }

    public ItemStack getItem(int lot, int slot) {
        return this.inventory.func_70301_a(lot * 10 + slot);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, e -> {
            if (this.isSpinning() || this.clientSpinning) {
                e.getController().setAnimation(new AnimationBuilder().addAnimation("spin", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                e.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
            return PlayState.CONTINUE;
        }));
    }

    public static enum BetType {
        CASH,
        CREDITS;

    }
}

