/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.slot_machine;

import fr.reluije.pixeomongocasino.tileentities.slot_machine.ItemConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.MoneyConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.PokemonConfiguration;
import fr.reluije.pixeomongocasino.utils.ServerPixelmonHelper;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public abstract class Configuration {
    public static final byte MONEY = 1;
    public static final byte POKEMON = 2;
    public static final byte ITEM = 3;
    private final byte type;
    private double chance;
    private int bet;

    protected Configuration(byte type) {
        this(type, 0.0, 0);
    }

    protected Configuration(byte type, double chance, int bet) {
        this.type = type;
        this.chance = chance;
        this.bet = bet;
    }

    public String getName() {
        return this.type == 1 ? "money" : (this.type == 2 ? "pokemon" : "item");
    }

    public int getBet() {
        return this.bet;
    }

    public double getChance() {
        return this.chance;
    }

    public void write(@Nonnull CompoundNBT compound) {
        compound.func_74774_a("Type", this.type);
        compound.func_74780_a("Chance", this.chance);
        compound.func_74768_a("Bet", this.bet);
    }

    @Nonnull
    public Configuration read(@Nonnull CompoundNBT compound) {
        this.chance = compound.func_74769_h("Chance");
        this.bet = compound.func_74762_e("Bet");
        return this;
    }

    public boolean isValid() {
        return this.chance > 0.0 && this.chance <= 100.0;
    }

    public boolean check(PlayerEntity player) {
        return ServerPixelmonHelper.getMoney(player).compareTo(BigDecimal.valueOf(this.getBet())) >= 0;
    }

    public abstract Configuration give(PlayerEntity var1);

    public abstract void return2Owner(PlayerEntity var1);

    @Nullable
    static Configuration create(@Nonnull CompoundNBT compound) {
        byte type = compound.func_74771_c("Type");
        switch (type) {
            case 1: {
                return new MoneyConfiguration().read(compound);
            }
            case 2: {
                return new PokemonConfiguration().read(compound);
            }
            case 3: {
                return new ItemConfiguration().read(compound);
            }
        }
        return null;
    }
}

