/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.slot_machine;

import fr.reluije.pixeomongocasino.tileentities.slot_machine.Configuration;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ItemConfiguration
extends Configuration {
    private CompoundNBT itemNBT;
    private ItemStack item;

    public ItemConfiguration() {
        super((byte)3);
    }

    public ItemConfiguration(double chance, int bet, CompoundNBT item) {
        super((byte)3, chance, bet);
        this.itemNBT = item;
    }

    @Override
    public void write(@Nonnull CompoundNBT compound) {
        super.write(compound);
        compound.func_218657_a("Item", (INBT)this.itemNBT);
    }

    @Override
    @Nonnull
    public Configuration read(@Nonnull CompoundNBT compound) {
        super.read(compound);
        this.itemNBT = compound.func_74775_l("Item");
        return this;
    }

    @Override
    public boolean check(PlayerEntity player) {
        return this.hasEmptySlot(player) && super.check(player);
    }

    @Override
    public Configuration give(PlayerEntity player) {
        this.giveItemToPlayer(player, this.getItem());
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.won.item"), false);
        return null;
    }

    @Override
    public void return2Owner(PlayerEntity owner) {
        if (this.hasEmptySlot(owner)) {
            this.giveItemToPlayer(owner, this.getItem());
        }
    }

    private boolean hasEmptySlot(PlayerEntity player) {
        int emptySlots = 0;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots > 0;
    }

    public ItemStack getItem() {
        if (this.item == null) {
            this.item = ItemStack.func_199557_a((CompoundNBT)this.itemNBT);
        }
        return this.item;
    }

    private void giveItemToPlayer(PlayerEntity player, ItemStack item) {
        player.field_71071_by.func_70441_a(item);
    }
}

