/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.slot_machine;

import fr.reluije.pixeomongocasino.tileentities.slot_machine.Configuration;
import fr.reluije.pixeomongocasino.utils.ServerPixelmonHelper;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MoneyConfiguration
extends Configuration {
    private int bank;
    private int multiplier;

    public MoneyConfiguration(double chance, int bet, int bank, int multiplier) {
        super((byte)1, chance, bet);
        this.bank = bank;
        this.multiplier = multiplier;
    }

    public MoneyConfiguration() {
        super((byte)1);
    }

    public int getBank() {
        return this.bank;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void write(@Nonnull CompoundNBT compound) {
        super.write(compound);
        compound.func_74768_a("Bank", this.bank);
        compound.func_74768_a("Multiplier", this.multiplier);
    }

    @Override
    @Nonnull
    public Configuration read(@Nonnull CompoundNBT compound) {
        super.read(compound);
        this.bank = compound.func_74762_e("Bank");
        this.multiplier = compound.func_74762_e("Multiplier");
        return this;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        long toGive = (long)this.getBet() * (long)this.multiplier;
        if (toGive <= 0L || toGive >= Integer.MAX_VALUE) {
            return false;
        }
        return (int)toGive <= this.bank;
    }

    @Override
    public Configuration give(PlayerEntity player) {
        int toGive = this.getBet() * this.multiplier;
        this.bank -= toGive;
        ServerPixelmonHelper.changeMoney(player, BigDecimal.valueOf(toGive));
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.won.money"), false);
        return this;
    }

    @Override
    public void return2Owner(PlayerEntity owner) {
        ServerPixelmonHelper.changeMoney(owner, BigDecimal.valueOf(this.bank));
    }
}

