/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.slot_machine;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.Configuration;
import fr.reluije.pixeomongocasino.utils.ServerPixelmonHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PokemonConfiguration
extends Configuration {
    private CompoundNBT pokemonNBT;
    private Pokemon pokemon;

    public PokemonConfiguration() {
        super((byte)2);
    }

    public PokemonConfiguration(double chance, int bet, CompoundNBT pokemon) {
        super((byte)2, chance, bet);
        this.pokemonNBT = pokemon;
    }

    @Override
    public void write(@Nonnull CompoundNBT compound) {
        super.write(compound);
        compound.func_218657_a("Pokemon", (INBT)this.pokemonNBT);
    }

    @Override
    @Nonnull
    public Configuration read(@Nonnull CompoundNBT compound) {
        super.read(compound);
        this.pokemonNBT = compound.func_74775_l("Pokemon");
        return this;
    }

    @Override
    public boolean check(PlayerEntity player) {
        return ServerPixelmonHelper.hasPCSpace(player) && super.check(player);
    }

    @Override
    public Configuration give(PlayerEntity player) {
        ServerPixelmonHelper.givePokemon(player, this.getPokemon());
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.won.pokemon"), false);
        return null;
    }

    @Override
    public void return2Owner(PlayerEntity owner) {
        ServerPixelmonHelper.givePokemon(owner, this.getPokemon());
    }

    public Pokemon getPokemon() {
        if (this.pokemon == null && this.pokemonNBT != null) {
            try {
                this.pokemon = PokemonFactory.create((CompoundNBT)this.pokemonNBT);
            }
            catch (Exception e) {
                this.pokemon = null;
                PixelmonGoCasino.LOGGER.error("Failed to create pokemon from NBT", (Throwable)e);
            }
        }
        return this.pokemon;
    }
}

