/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.tileentities.slot_machine;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import fr.reluije.pixeomongocasino.network.Network;
import fr.reluije.pixeomongocasino.network.OpenSlotMachinePacket;
import fr.reluije.pixeomongocasino.network.PlayAnimationPacket;
import fr.reluije.pixeomongocasino.tileentities.BaseCasinoMachine;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.Configuration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.ItemConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.MoneyConfiguration;
import fr.reluije.pixeomongocasino.tileentities.slot_machine.PokemonConfiguration;
import fr.reluije.pixeomongocasino.utils.CasinoHelper;
import fr.reluije.pixeomongocasino.utils.ServerPixelmonHelper;
import java.math.BigDecimal;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import ua.realalpha.pokemonapi.PokemonSyncApi;
import ua.realalpha.pokemonapi.RabbitMqPacketBridge;

public class SlotMachineTileEntity
extends BaseCasinoMachine {
    public static final long SPINNING_LENGTH = 4000L;
    private Configuration configuration;
    public boolean win;
    private PlayerEntity spinningPlayer;
    private long animationStart = -1L;
    private int waitingCash;

    public SlotMachineTileEntity() {
        super((TileEntityType<? extends BaseCasinoMachine>)((TileEntityType)PixelmonGoCasino.TE_SLOT_MACHINE.get()));
    }

    @Override
    public PlayerEntity getSpinningPlayer() {
        return this.spinningPlayer;
    }

    @Override
    public void return2Owner(PlayerEntity owner) {
        this.getConfiguration().return2Owner(owner);
    }

    @Override
    public void openConfigurationMenu(PlayerEntity player) {
        Network.openCashMachineMenu(player, this.func_174877_v(), OpenSlotMachinePacket.MenuType.CONFIG, false);
    }

    @Override
    public void play(PlayerEntity player) {
        this.spin(player);
    }

    @Override
    public void startAnimation() {
        this.animationStart = System.currentTimeMillis();
    }

    public long getAnimationTime() {
        return System.currentTimeMillis() - this.animationStart;
    }

    public boolean isSpinning() {
        return this.animationStart > 0L && System.currentTimeMillis() - this.animationStart < 4000L;
    }

    @Override
    public boolean isConfigured() {
        return this.ownerId != null && this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean canRun() {
        return this.isConfigured() && this.getConfiguration().isValid();
    }

    public void setPokemonConfiguration(PlayerEntity player, double chance, int bet, UUID pokemonId) {
        PlayerPartyStorage playerStorage = ServerPixelmonHelper.getPlayerStorage(player);
        if (bet <= 0 || chance <= 0.0 || chance > 100.0) {
            return;
        }
        if (playerStorage.countPokemon() <= 1) {
            return;
        }
        Pokemon pokemon = playerStorage.get(pokemonId);
        if (pokemon == null) {
            return;
        }
        if (!pokemon.isUnbreedable() && pokemon.hasHiddenAbility()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.hidden_ability"), false);
            return;
        }
        pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("Forced"));
        playerStorage.set(playerStorage.getSlot(pokemonId), null);
        this.configuration = new PokemonConfiguration(chance, bet, pokemon.writeToNBT(new CompoundNBT()));
        player.func_71053_j();
        this.sync();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.configured"), false);
    }

    public void setMoneyConfiguration(PlayerEntity player, double chance, int bet, int bank, int multiplier) {
        BigDecimal money = ServerPixelmonHelper.getMoney(player);
        if ((double)bank <= 0.0 || (double)bet <= 0.0 || (double)multiplier <= 0.0) {
            return;
        }
        if (money.compareTo(BigDecimal.valueOf(bank)) < 0) {
            return;
        }
        if (chance <= 0.0 || chance > 100.0) {
            return;
        }
        int value = bet * multiplier;
        if (value <= 0 || value > bank) {
            return;
        }
        ServerPixelmonHelper.changeMoney(player, BigDecimal.valueOf(bank).negate());
        this.configuration = new MoneyConfiguration(chance, bet, bank, multiplier);
        player.func_71053_j();
        this.sync();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.configured"), false);
    }

    public void setItemConfiguration(PlayerEntity player, double chance, int bet, int slotItem) {
        if (bet <= 0 || chance <= 0.0 || chance > 100.0) {
            return;
        }
        if (player.field_71071_by.func_191420_l()) {
            return;
        }
        ItemStack item = player.field_71071_by.func_70301_a(slotItem);
        if (item == null || item.func_190926_b()) {
            return;
        }
        player.field_71071_by.func_70304_b(slotItem);
        this.configuration = new ItemConfiguration(chance, bet, item.func_77955_b(new CompoundNBT()));
        player.func_71053_j();
        this.sync();
        player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.configured"), false);
    }

    public void spin(PlayerEntity player) {
        if (this.func_145831_w() == null) {
            throw new IllegalStateException("No world");
        }
        if (this.isSpinning()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.already_running"), false);
            return;
        }
        if (!this.canRun()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.cannot_run"), false);
            return;
        }
        if (!this.configuration.check(player)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.check_configuration." + this.configuration.getName()), false);
            return;
        }
        ServerPixelmonHelper.changeMoney(player, BigDecimal.valueOf(this.configuration.getBet()).negate());
        this.win = CasinoHelper.randomDouble(0.0, 100.0) <= this.configuration.getChance();
        ServerPixelmonHelper.changeMoney(this.ownerId, BigDecimal.valueOf(this.configuration.getBet()));
        PokemonSyncApi pokemonSyncApi = PokemonSyncApi.getInstance();
        RabbitMqPacketBridge rabbitMqPacketBridge = pokemonSyncApi.getRabbitMqPacketBridge();
        rabbitMqPacketBridge.sendMessage(this.ownerId, "\u00a77[\u00a7a+\u00a77] \u00a7fVous avez gagn\u00e9 \u00a7a+" + this.configuration.getBet() + "\u00a7f gr\u00e2ce au joueur " + player.func_200200_C_().getString() + " \u00e0 votre Casino.");
        this.spinningPlayer = player;
        this.startAnimation();
        this.sync();
        Network.sendToAllAround(new PlayAnimationPacket(this.field_174879_c), this.field_174879_c, this.func_145831_w(), 32.0);
        Network.openCashMachineMenu(player, this.field_174879_c, OpenSlotMachinePacket.MenuType.BET, this.win);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("WaitingCash", this.waitingCash);
        if (this.configuration != null) {
            CompoundNBT configurationNBT = new CompoundNBT();
            this.configuration.write(configurationNBT);
            compound.func_218657_a("Configuration", (INBT)configurationNBT);
        }
        return compound;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.waitingCash = compound.func_74762_e("WaitingCash");
        this.configuration = compound.func_150297_b("Configuration", 10) ? Configuration.create(compound.func_74775_l("Configuration")) : null;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world == null || world.func_73046_m() == null || world.func_201670_d()) {
            return;
        }
        if (this.ownerId == null) {
            return;
        }
        if (this.spinningPlayer != null && this.animationStart > 0L && this.canRun() && !this.isSpinning()) {
            if (this.win) {
                this.configuration = this.configuration.give(this.spinningPlayer);
                this.sync();
            } else {
                this.spinningPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("slot_machine.lost"), false);
            }
            this.spinningPlayer.func_71053_j();
            this.animationStart = -1L;
            this.spinningPlayer = null;
            this.win = false;
        }
    }

    @Override
    public boolean canStillConfigured() {
        return false;
    }

    @Override
    public boolean hasResourceInside() {
        return this.isConfigured();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, e -> {
            if (this.isSpinning()) {
                if (this.win) {
                    e.getController().setAnimation(new AnimationBuilder().addAnimation("spin_win_1", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                } else {
                    e.getController().setAnimation(new AnimationBuilder().addAnimation("spin_no_win", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                }
            } else {
                e.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            }
            return PlayState.CONTINUE;
        }));
    }
}

