/*
 * Decompiled with CFR 0.152.
 */
package fr.reluije.pixeomongocasino.utils;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import fr.reluije.pixeomongocasino.PixelmonGoCasino;
import java.math.BigDecimal;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.entity.player.PlayerEntity;
import re.como.playerpoints.api.PlayerPoints;
import re.como.playerpoints.api.PlayerPointsProfile;
import re.como.playerpoints.api.exception.PlayerPointsProfileDoesntHaveEnoughPoints;

public class ServerPixelmonHelper {
    public static PlayerPartyStorage getPlayerStorage(PlayerEntity player) {
        return StorageProxy.getParty((UUID)player.func_110124_au());
    }

    public static PCStorage getPC(PlayerEntity player) {
        return StorageProxy.getPCForPlayer((UUID)player.func_110124_au());
    }

    public static BigDecimal getMoney(PlayerEntity player) {
        return ServerPixelmonHelper.getPlayerStorage(player).getBalance();
    }

    public static void changeMoney(PlayerEntity player, BigDecimal amount) {
        PlayerPartyStorage playerStorage = ServerPixelmonHelper.getPlayerStorage(player);
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            playerStorage.add(amount);
        } else {
            playerStorage.take(amount.abs());
        }
    }

    public static void changeMoney(UUID player, BigDecimal amount) {
        PlayerPartyStorage playerStorage = StorageProxy.getParty((UUID)player);
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            playerStorage.add(amount);
        } else {
            playerStorage.take(amount.abs());
        }
    }

    public static boolean hasPCSpace(PlayerEntity player) {
        return ServerPixelmonHelper.getPC(player).hasSpace();
    }

    public static void givePokemon(PlayerEntity player, Pokemon pokemon) {
        ServerPixelmonHelper.getPC(player).add(pokemon);
    }

    public static long getCredits(PlayerEntity player) {
        if (PlayerPoints.getInstance() == null) {
            if (player.func_184812_l_()) {
                PixelmonGoCasino.LOGGER.warn("PlayerPoints API is null, simulating 1000 credits for player {}", (Object)player.func_200200_C_().getString());
                return 1000L;
            }
            PixelmonGoCasino.LOGGER.error("PlayerPoints API is null, simulating 0 credits for player {}", (Object)player.func_200200_C_().getString());
            return 0L;
        }
        AtomicLong credits = new AtomicLong();
        try {
            PlayerPoints.getInstance().getProfile(player.func_110124_au()).get().ifPresent(profile -> credits.set(profile.getPoints().get()));
        }
        catch (InterruptedException | ExecutionException e) {
            PixelmonGoCasino.LOGGER.error("Error while getting credits for player {}", (Object)player.func_200200_C_().getString());
        }
        return credits.get();
    }

    public static void changeCredits(PlayerEntity player, long amount) {
        if (PlayerPoints.getInstance() == null) {
            PixelmonGoCasino.LOGGER.error("PlayerPoints API is null, cannot change credits for player {}", (Object)player.func_200200_C_().getString());
            return;
        }
        try {
            PlayerPointsProfile profile = PlayerPoints.getInstance().getProfile(player.func_110124_au()).get().orElse(null);
            if (profile == null) {
                PixelmonGoCasino.LOGGER.error("PlayerPoints profile is null, cannot change credits for player {}", (Object)player.func_200200_C_().getString());
                return;
            }
            if (amount > 0L) {
                profile.increasePoints(amount);
            } else if (amount < 0L) {
                profile.decreasePoints(-amount);
            } else {
                PixelmonGoCasino.LOGGER.error("Amount is null, cannot change credits for player {}", (Object)player.func_200200_C_().getString());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            PixelmonGoCasino.LOGGER.error("Error while changing credits for player {}", (Object)player.func_200200_C_().getString());
        }
        catch (PlayerPointsProfileDoesntHaveEnoughPoints e) {
            throw new RuntimeException(e);
        }
    }
}

