/*
 * Decompiled with CFR 0.152.
 */
package ua.realalpha.pokemonapi;

import com.mojang.authlib.GameProfile;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.EconomyEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import java.math.BigDecimal;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class InjectedPlayerPartyStorage
extends PlayerPartyStorage {
    public InjectedPlayerPartyStorage(UUID uuid, boolean shouldSendUpdates) {
        super(uuid, shouldSendUpdates);
    }

    public InjectedPlayerPartyStorage(UUID uuid) {
        super(uuid);
    }

    public void UNSAFE_setBalance(BigDecimal balance) {
        this.pokeDollars = balance;
        this.updatePlayer(this.pokeDollars);
        this.setNeedsSaving();
    }

    public void setBalance(BigDecimal amount) {
        ServerPlayerEntity safePlayer = this.getSafePlayer();
        EconomyEvent.SetBalance event = new EconomyEvent.SetBalance(safePlayer, (BankAccount)this, amount);
        if (!Pixelmon.EVENT_BUS.post((Event)event)) {
            this.pokeDollars = event.getBalance();
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
        }
    }

    public boolean add(BigDecimal amount) {
        EconomyEvent.PreTransaction preEvent;
        if (amount.intValue() < 0) {
            Pixelmon.LOGGER.error("Cannot add a negative amount to bank account for " + this.playerName);
            return false;
        }
        BigDecimal accuratePokeDollars = this.pokeDollars;
        BigDecimal oldBalance = this.pokeDollars;
        ServerPlayerEntity safePlayer = this.getSafePlayer();
        if (safePlayer instanceof FakePlayer || safePlayer.func_193105_t()) {
            accuratePokeDollars = BigDecimal.ZERO;
            oldBalance = BigDecimal.ZERO;
        }
        if (!Pixelmon.EVENT_BUS.post((Event)(preEvent = new EconomyEvent.PreTransaction(safePlayer, (BankAccount)this, EconomyEvent.TransactionType.DEPOSIT, accuratePokeDollars, amount)))) {
            this.pokeDollars = accuratePokeDollars.add(amount);
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransaction(safePlayer, (BankAccount)this, EconomyEvent.TransactionType.DEPOSIT, oldBalance, this.pokeDollars));
            return true;
        }
        return false;
    }

    public boolean take(BigDecimal amount) {
        EconomyEvent.PreTransaction preEvent;
        ServerPlayerEntity safePlayer = this.getSafePlayer();
        if (amount.intValue() < 0 && !(safePlayer instanceof FakePlayer)) {
            Pixelmon.LOGGER.error("Cannot take a negative amount from bank account for " + this.playerName);
            return false;
        }
        BigDecimal accuratePokeDollars = this.pokeDollars;
        BigDecimal oldBalance = this.pokeDollars;
        if (safePlayer instanceof FakePlayer) {
            accuratePokeDollars = BigDecimal.ZERO;
            oldBalance = BigDecimal.ZERO;
            System.out.println("Creating fake player for " + this.playerName);
        }
        if (!Pixelmon.EVENT_BUS.post((Event)(preEvent = new EconomyEvent.PreTransaction(safePlayer, (BankAccount)this, EconomyEvent.TransactionType.WITHDRAW, accuratePokeDollars, amount)))) {
            this.pokeDollars = accuratePokeDollars.subtract(preEvent.getChange());
            this.updatePlayer(this.pokeDollars);
            this.setNeedsSaving();
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransaction(safePlayer, (BankAccount)this, EconomyEvent.TransactionType.WITHDRAW, oldBalance, this.pokeDollars));
            return true;
        }
        return false;
    }

    private ServerPlayerEntity getSafePlayer() {
        ServerPlayerEntity player = this.getPlayer();
        if (player == null) {
            MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
            ServerWorld world = minecraftServer.func_241755_D_();
            return new FakePlayer(world, new GameProfile(this.uuid, this.playerName));
        }
        return player;
    }
}

