/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo;

import com.mojang.brigadier.CommandDispatcher;
import com.zordix.pixelmongo.client.ClientKeyHandler;
import com.zordix.pixelmongo.client.DailyPlaytimeOverlay;
import com.zordix.pixelmongo.client.PlaytimeClient;
import com.zordix.pixelmongo.commands.DailyPlaytimeCommand;
import com.zordix.pixelmongo.config.DatabaseConfig;
import com.zordix.pixelmongo.config.PixelDailyConfig;
import com.zordix.pixelmongo.data.PlayerDataManager;
import com.zordix.pixelmongo.events.PlayerEventHandler;
import com.zordix.pixelmongo.network.NetworkHandler;
import com.zordix.pixelmongo.placeholders.PlaceholderProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pixeldaily")
public class PixelDaily {
    public static final String MODID = "pixeldaily";
    public static final Logger LOGGER = LogManager.getLogger();
    private static PixelDaily instance;
    private PlayerDataManager playerDataManager;
    private PlayerEventHandler playerEventHandler;

    public PixelDaily() {
        instance = this;
        LOGGER.info("Initializing PixelDaily mod...");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, PixelDailyConfig.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.playerDataManager != null) {
                this.playerDataManager.emergencyShutdownSave();
            }
        }));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("[SETUP] Enregistrement du canal r\u00e9seau...");
        event.enqueueWork(() -> {
            try {
                this.playerDataManager = new PlayerDataManager();
                LOGGER.info("[SETUP] PlayerDataManager cr\u00e9\u00e9");
                this.playerEventHandler = new PlayerEventHandler();
                MinecraftForge.EVENT_BUS.register((Object)this.playerEventHandler);
                LOGGER.info("[SETUP] PlayerEventHandler enregistr\u00e9");
                NetworkHandler.register();
                LOGGER.info("[SETUP] NetworkHandler enregistr\u00e9");
                PlaceholderProvider.register();
                LOGGER.info("[SETUP] PlaceholderProvider enregistr\u00e9");
                DatabaseConfig.initializeDataSource();
                LOGGER.info("[SETUP] DatabaseConfig initialis\u00e9");
                LOGGER.info("PixelDaily setup completed successfully");
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize PixelDaily", (Throwable)e);
                throw new RuntimeException("PixelDaily initialization failed", e);
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("[CLIENT SETUP] Enregistrement des \u00e9v\u00e9nements client...");
        event.enqueueWork(() -> {
            try {
                NetworkHandler.register();
                LOGGER.info("[CLIENT SETUP] NetworkHandler enregistr\u00e9 c\u00f4t\u00e9 CLIENT");
                MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
                LOGGER.info("[CLIENT SETUP] ClientEventHandler enregistr\u00e9");
                DailyPlaytimeOverlay overlay = new DailyPlaytimeOverlay();
                MinecraftForge.EVENT_BUS.register((Object)overlay);
                LOGGER.info("[CLIENT SETUP] DailyPlaytimeOverlay enregistr\u00e9");
                MinecraftForge.EVENT_BUS.register(ClientKeyHandler.class);
                LOGGER.info("[CLIENT SETUP] ClientKeyHandler enregistr\u00e9 - Keybind M activ\u00e9e");
                LOGGER.info("[CLIENT SETUP] Client setup completed successfully");
            }
            catch (Exception e) {
                LOGGER.error("[CLIENT SETUP] Failed to initialize client", (Throwable)e);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        DailyPlaytimeCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public static PixelDaily getInstance() {
        return instance;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public static class ClientEventHandler {
        @SubscribeEvent
        public void onClientPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            PlayerEntity player = event.getPlayer();
            if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K) {
                LOGGER.info("[CLIENT] Player disconnected - Resetting client data");
                PlaytimeClient.clearData();
            }
        }

        @SubscribeEvent
        public void onClientPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            if (player != null && player.field_70170_p != null && player.field_70170_p.field_72995_K) {
                LOGGER.info("[CLIENT] Player connected - Client ready");
                PlaytimeClient.clearData();
            }
        }
    }
}

