/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.zordix.pixelmongo.client.PlaytimeClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DailyPlaytimeOverlay {
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (mc.field_71462_r != null && mc.field_71462_r.getClass().getName().contains("Chat")) {
            return;
        }
        if (!PlaytimeClient.isHudEnabled()) {
            return;
        }
        MatrixStack matrixStack = event.getMatrixStack();
        String headerText = PlaytimeClient.getFormattedHeader();
        String displayText = PlaytimeClient.getDisplayText();
        if ((headerText == null || headerText.isEmpty()) && (displayText == null || displayText.isEmpty())) {
            return;
        }
        headerText = this.compactTimeFormat(headerText);
        ITextComponent headerComponent = this.formatText(headerText);
        ITextComponent displayComponent = this.formatText(displayText);
        int headerWidth = mc.field_71466_p.func_238414_a_((ITextProperties)headerComponent);
        int displayWidth = mc.field_71466_p.func_238414_a_((ITextProperties)displayComponent);
        int maxWidth = Math.max(headerWidth, displayWidth);
        mc.field_71466_p.getClass();
        int textHeight = 9;
        int x = 2;
        int screenHeight = mc.func_228018_at_().func_198091_l();
        int scaledHeight = screenHeight / (int)mc.func_228018_at_().func_198100_s();
        int y = scaledHeight - textHeight * 2 - 2;
        if (headerText != null && !headerText.isEmpty()) {
            this.drawTextBlock(matrixStack, x, y, headerComponent, maxWidth, textHeight);
            y += textHeight + 4;
        }
        if (displayText != null && !displayText.isEmpty()) {
            this.drawTextBlock(matrixStack, x, y, displayComponent, maxWidth, textHeight);
        }
    }

    private String compactTimeFormat(String text) {
        if (text == null) {
            return text;
        }
        return text.replaceAll(" ([0-9]+[dhms])", "$1");
    }

    private void drawTextBlock(MatrixStack matrixStack, int x, int y, ITextComponent text, int width, int height) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x - 2), (int)(y - 2), (int)(x + width + 2), (int)(y + height + 2), (int)0x44000000);
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, text, (float)(x + 2), (float)y, 0xFFFFFF);
    }

    private ITextComponent formatText(String text) {
        if (text == null || text.isEmpty()) {
            return new StringTextComponent("");
        }
        String formattedText = text.replace("&0", TextFormatting.BLACK.toString()).replace("&1", TextFormatting.DARK_BLUE.toString()).replace("&2", TextFormatting.DARK_GREEN.toString()).replace("&3", TextFormatting.DARK_AQUA.toString()).replace("&4", TextFormatting.DARK_RED.toString()).replace("&5", TextFormatting.DARK_PURPLE.toString()).replace("&6", TextFormatting.GOLD.toString()).replace("&7", TextFormatting.GRAY.toString()).replace("&8", TextFormatting.DARK_GRAY.toString()).replace("&9", TextFormatting.BLUE.toString()).replace("&a", TextFormatting.GREEN.toString()).replace("&b", TextFormatting.AQUA.toString()).replace("&c", TextFormatting.RED.toString()).replace("&d", TextFormatting.LIGHT_PURPLE.toString()).replace("&e", TextFormatting.YELLOW.toString()).replace("&f", TextFormatting.WHITE.toString()).replace("&l", TextFormatting.BOLD.toString()).replace("&m", TextFormatting.STRIKETHROUGH.toString()).replace("&n", TextFormatting.UNDERLINE.toString()).replace("&o", TextFormatting.ITALIC.toString()).replace("&r", TextFormatting.RESET.toString());
        return new StringTextComponent(formattedText);
    }
}

