/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.client;

import com.zordix.pixelmongo.PixelDaily;

public class PlaytimeClient {
    private static long NEXT_REWARD_SECONDS = 0L;
    private static long CURRENT_PLAYTIME_SECONDS = 0L;
    private static long LAST_UPDATED = 0L;
    private static String DISPLAY_HEADER = "";
    private static String DISPLAY_TEXT = "";
    private static boolean HUD_ENABLED = true;
    private static long LAST_SERVER_PLAYTIME = 0L;
    private static long LAST_CLIENT_CALCULATION = 0L;
    private static final long MAX_CLIENT_DRIFT_MS = 3000L;

    public static void updateFromServer(long currentPlaytimeSeconds, long nextRewardSeconds, String header, String display) {
        long now = System.currentTimeMillis();
        PixelDaily.LOGGER.debug("[CLIENT] Mise \u00e0 jour re\u00e7ue - Serveur: " + currentPlaytimeSeconds + "s");
        HUD_ENABLED = true;
        if (LAST_UPDATED == 0L) {
            CURRENT_PLAYTIME_SECONDS = currentPlaytimeSeconds;
            LAST_SERVER_PLAYTIME = currentPlaytimeSeconds;
            LAST_UPDATED = now;
            LAST_CLIENT_CALCULATION = currentPlaytimeSeconds;
            PixelDaily.LOGGER.debug("[CLIENT] Premi\u00e8re initialisation: " + currentPlaytimeSeconds + "s");
        } else {
            long timeSinceLastUpdate = now - LAST_UPDATED;
            long serverChange = currentPlaytimeSeconds - LAST_SERVER_PLAYTIME;
            CURRENT_PLAYTIME_SECONDS = currentPlaytimeSeconds;
            long expectedChange = timeSinceLastUpdate / 1000L;
            if (Math.abs(serverChange - expectedChange) > 10L) {
                PixelDaily.LOGGER.warn("[CLIENT] D\u00e9synchronisation d\u00e9tect\u00e9e (expected: " + expectedChange + "s, actual: " + serverChange + "s)");
            }
        }
        LAST_SERVER_PLAYTIME = currentPlaytimeSeconds;
        NEXT_REWARD_SECONDS = nextRewardSeconds;
        DISPLAY_HEADER = header != null ? header : "";
        DISPLAY_TEXT = display != null ? display : "";
        LAST_UPDATED = now;
        LAST_CLIENT_CALCULATION = currentPlaytimeSeconds;
        PixelDaily.LOGGER.debug("[CLIENT] HUD r\u00e9activ\u00e9 - donn\u00e9es mises \u00e0 jour");
    }

    public static boolean isDataValid() {
        return LAST_UPDATED > 0L && System.currentTimeMillis() - LAST_UPDATED < 5000L;
    }

    public static long getCurrentPlaytimeSeconds() {
        if (!PlaytimeClient.isDataValid()) {
            return CURRENT_PLAYTIME_SECONDS;
        }
        long now = System.currentTimeMillis();
        long timeSinceLastUpdate = now - LAST_UPDATED;
        if (timeSinceLastUpdate > 3000L) {
            return CURRENT_PLAYTIME_SECONDS;
        }
        long extrapolatedSeconds = CURRENT_PLAYTIME_SECONDS + timeSinceLastUpdate / 1000L;
        long maxAllowedExtrapolation = 3L;
        if ((extrapolatedSeconds = Math.min(extrapolatedSeconds, LAST_SERVER_PLAYTIME + maxAllowedExtrapolation)) < LAST_CLIENT_CALCULATION) {
            return LAST_CLIENT_CALCULATION;
        }
        LAST_CLIENT_CALCULATION = extrapolatedSeconds;
        return extrapolatedSeconds;
    }

    public static long getTimeUntilNextReward() {
        if (!PlaytimeClient.isDataValid()) {
            return 0L;
        }
        long currentPlaytime = PlaytimeClient.getCurrentPlaytimeSeconds();
        long timeLeft = NEXT_REWARD_SECONDS - currentPlaytime;
        return Math.max(0L, timeLeft);
    }

    public static String getFormattedTimeUntilReward() {
        if (!PlaytimeClient.isDataValid()) {
            return "";
        }
        long secondsLeft = PlaytimeClient.getTimeUntilNextReward();
        if (secondsLeft <= 0L) {
            return "R\u00e9compense disponible !";
        }
        long days = secondsLeft / 86400L;
        long hours = secondsLeft % 86400L / 3600L;
        long minutes = secondsLeft % 3600L / 60L;
        long seconds = secondsLeft % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    public static String getFormattedHeader() {
        if (!PlaytimeClient.isDataValid()) {
            return "";
        }
        String formattedTime = PlaytimeClient.getFormattedTimeUntilReward();
        String headerToUse = DISPLAY_HEADER;
        return headerToUse.replace("%PLAYTIME%", formattedTime);
    }

    public static String getDisplayText() {
        if (!PlaytimeClient.isDataValid() || DISPLAY_TEXT == null) {
            return "";
        }
        return DISPLAY_TEXT;
    }

    public static boolean hasData() {
        return PlaytimeClient.isDataValid() && !DISPLAY_HEADER.isEmpty() && !DISPLAY_TEXT.isEmpty();
    }

    public static boolean isHudEnabled() {
        return HUD_ENABLED;
    }

    public static void setHudEnabled(boolean enabled) {
        HUD_ENABLED = enabled;
    }

    public static void clearData() {
        CURRENT_PLAYTIME_SECONDS = 0L;
        NEXT_REWARD_SECONDS = 0L;
        LAST_UPDATED = 0L;
        DISPLAY_HEADER = "";
        DISPLAY_TEXT = "";
        LAST_SERVER_PLAYTIME = 0L;
        LAST_CLIENT_CALCULATION = 0L;
    }

    public static void disableHud() {
        HUD_ENABLED = false;
        PlaytimeClient.clearData();
        PixelDaily.LOGGER.info("[CLIENT] \u00e2\u0153\u2026 HUD D\u00c9SACTIV\u00c9 - Mode FORC\u00c9 OFF");
    }

    public static String getDebugInfo() {
        if (!PlaytimeClient.isDataValid()) {
            return "No data";
        }
        return String.format("Server: %ds | Client: %ds | Drift: %dms | Last Update: %dms ago | HUD: %s", LAST_SERVER_PLAYTIME, PlaytimeClient.getCurrentPlaytimeSeconds(), System.currentTimeMillis() - LAST_UPDATED, System.currentTimeMillis() - LAST_UPDATED, HUD_ENABLED);
    }
}

