/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.config.PixelDailyConfig;
import com.zordix.pixelmongo.data.PlayerDataManager;
import com.zordix.pixelmongo.network.NetworkHandler;
import com.zordix.pixelmongo.rewards.RewardManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class DailyPlaytimeCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dailyplaytime").requires(source -> true)).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"action", (ArgumentType)StringArgumentType.word()).requires(source -> true)).executes(DailyPlaytimeCommand::execute))).executes(DailyPlaytimeCommand::executeInfo));
    }

    private static int execute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (!(source.func_197022_f() instanceof ServerPlayerEntity)) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)source.func_197022_f();
        String action = StringArgumentType.getString(context, (String)"action");
        PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
        switch (action.toLowerCase()) {
            case "off": {
                dataManager.setHudEnabled(player.func_110124_au(), false);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "\u2713 HUD Daily Playtime d\u00e9sactiv\u00e9."), player.func_110124_au());
                NetworkHandler.sendToPlayer(new NetworkHandler.PlaytimeUpdatePacket(0L, 0L, "", ""), player);
                PixelDaily.LOGGER.info("[COMMAND] " + player.func_200200_C_().getString() + " a d\u00e9sactiv\u00e9 le HUD Daily Playtime");
                return 1;
            }
            case "on": {
                dataManager.setHudEnabled(player.func_110124_au(), true);
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "\u2713 HUD Daily Playtime activ\u00e9."), player.func_110124_au());
                DailyPlaytimeCommand.forceHudUpdate(player, dataManager);
                PixelDaily.LOGGER.info("[COMMAND] " + player.func_200200_C_().getString() + " a activ\u00e9 le HUD Daily Playtime");
                return 1;
            }
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "\u2717 Usage: /dailyplaytime <on|off>"), player.func_110124_au());
        return 0;
    }

    private static int executeInfo(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (!(source.func_197022_f() instanceof ServerPlayerEntity)) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)source.func_197022_f();
        PlayerDataManager dataManager = PixelDaily.getInstance().getPlayerDataManager();
        PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
        long playtimeSeconds = data.getDailyPlaytimeSeconds();
        long hours = playtimeSeconds / 3600L;
        long minutes = playtimeSeconds % 3600L / 60L;
        long seconds = playtimeSeconds % 60L;
        String timeFormat = String.format("%dh %dm %ds", hours, minutes, seconds);
        boolean hudStatus = dataManager.isHudEnabled(player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "=== Daily Playtime ==="), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Temps de jeu aujourd'hui: " + TextFormatting.WHITE + timeFormat), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Affichage HUD: " + (hudStatus ? TextFormatting.GREEN + "Activ\u00e9" : TextFormatting.RED + "D\u00e9sactiv\u00e9")), player.func_110124_au());
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Utilisez /dailyplaytime <on|off> pour modifier l'affichage"), player.func_110124_au());
        return 1;
    }

    private static void forceHudUpdate(ServerPlayerEntity player, PlayerDataManager dataManager) {
        try {
            PlayerDataManager.PlayerDailyData data = dataManager.getPlayerData(player.func_110124_au());
            data.synchronizeForClient();
            String nextRewardText = RewardManager.getNextRewardText(player, data);
            String header = (String)PixelDailyConfig.DAY_AFFICHAGE_HEADER.get();
            NetworkHandler.sendToPlayer(new NetworkHandler.PlaytimeUpdatePacket(data.getDailyPlaytimeSeconds(), RewardManager.getNextRewardTime(player, data), header, nextRewardText), player);
        }
        catch (Exception e) {
            PixelDaily.LOGGER.error("[COMMAND] Erreur lors de la mise \u00e0 jour forc\u00e9e du HUD", (Throwable)e);
        }
    }
}

