/*
 * Decompiled with CFR 0.152.
 */
package com.zordix.pixelmongo.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zordix.pixelmongo.PixelDaily;
import com.zordix.pixelmongo.config.PixelDailyConfig;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DatabaseConfig {
    private static HikariDataSource dataSource;

    public static void initializeDataSource() {
        try {
            HikariConfig config = new HikariConfig();
            String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC", PixelDailyConfig.MYSQL_HOST.get(), PixelDailyConfig.MYSQL_PORT.get(), PixelDailyConfig.MYSQL_DATABASE.get());
            config.setJdbcUrl(jdbcUrl);
            config.setUsername((String)PixelDailyConfig.MYSQL_USERNAME.get());
            config.setPassword((String)PixelDailyConfig.MYSQL_PASSWORD.get());
            config.setDriverClassName("com.mysql.cj.jdbc.Driver");
            config.setMaximumPoolSize(((Integer)PixelDailyConfig.MYSQL_MAX_POOL_SIZE.get()).intValue());
            dataSource = new HikariDataSource(config);
            PixelDaily.LOGGER.info("MySQL connection pool initialized successfully");
            try (Connection conn = dataSource.getConnection();){
                PixelDaily.LOGGER.info("Database connection test successful");
            }
        }
        catch (Exception e) {
            PixelDaily.LOGGER.error("Failed to initialize database connection pool", (Throwable)e);
            throw new RuntimeException("Failed to initialize database", e);
        }
    }

    public static Connection getConnection() throws SQLException {
        if (dataSource == null || dataSource.isClosed()) {
            DatabaseConfig.initializeDataSource();
        }
        return dataSource.getConnection();
    }

    public static DataSource getDataSource() {
        if (dataSource == null || dataSource.isClosed()) {
            DatabaseConfig.initializeDataSource();
        }
        return dataSource;
    }

    public static void closeDataSource() {
        if (dataSource != null && !dataSource.isClosed()) {
            dataSource.close();
            PixelDaily.LOGGER.info("Database connection pool closed");
        }
    }
}

